/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.function;

import java.util.Map;
import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import org.javamoney.moneta.function.DefaultMonetarySummaryStatistics;
import org.javamoney.moneta.function.MonetarySummaryMap;
import org.javamoney.moneta.function.MonetarySummaryStatistics;

public class GroupMonetarySummaryStatistics {
    private final Map<CurrencyUnit, MonetarySummaryStatistics> groupSummary = new MonetarySummaryMap();

    GroupMonetarySummaryStatistics() {
    }

    public Map<CurrencyUnit, MonetarySummaryStatistics> get() {
        return this.groupSummary;
    }

    public GroupMonetarySummaryStatistics accept(MonetaryAmount amount) {
        CurrencyUnit currency = Objects.requireNonNull(amount).getCurrency();
        MonetarySummaryStatistics summary = this.groupSummary.get(currency);
        if (summary == null) {
            summary = new DefaultMonetarySummaryStatistics(currency);
            this.groupSummary.put(currency, summary);
        }
        summary.accept(amount);
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.groupSummary);
    }

    public boolean equals(Object obj) {
        if (GroupMonetarySummaryStatistics.class.isInstance(obj)) {
            GroupMonetarySummaryStatistics other = (GroupMonetarySummaryStatistics)GroupMonetarySummaryStatistics.class.cast(obj);
            return Objects.equals(this.groupSummary, other.groupSummary);
        }
        return false;
    }

    public String toString() {
        return "GroupMonetarySummaryStatistics: " + this.groupSummary.toString();
    }

    public GroupMonetarySummaryStatistics combine(GroupMonetarySummaryStatistics another) {
        Objects.requireNonNull(another);
        for (CurrencyUnit keyCurrency : another.groupSummary.keySet()) {
            MonetarySummaryStatistics stats = this.groupSummary.get(keyCurrency);
            if (stats == null) {
                stats = new DefaultMonetarySummaryStatistics(keyCurrency);
                this.groupSummary.put(keyCurrency, stats);
            }
            MonetarySummaryStatistics oldValue = this.groupSummary.get(keyCurrency);
            MonetarySummaryStatistics newValue = another.groupSummary.get(keyCurrency);
            if (oldValue != null) {
                newValue = oldValue.combine(another.groupSummary.get(keyCurrency));
            }
            this.groupSummary.put(keyCurrency, newValue);
        }
        return this;
    }
}

