/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.function;

import java.util.Comparator;
import java.util.Objects;
import javax.money.MonetaryAmount;
import javax.money.convert.CurrencyConversion;
import javax.money.convert.ExchangeRateProvider;
import org.javamoney.moneta.spi.MoneyUtils;

public final class MonetaryFunctions {
    private static final Comparator<MonetaryAmount> NUMBER_COMPARATOR = new Comparator<MonetaryAmount>(){

        @Override
        public int compare(MonetaryAmount o1, MonetaryAmount o2) {
            return o1.getNumber().compareTo(o2.getNumber());
        }
    };
    private static final Comparator<MonetaryAmount> CURRENCY_COMPARATOR = new Comparator<MonetaryAmount>(){

        @Override
        public int compare(MonetaryAmount o1, MonetaryAmount o2) {
            return o1.getCurrency().compareTo((Object)o2.getCurrency());
        }
    };

    public static Comparator<MonetaryAmount> sortCurrencyUnit() {
        return CURRENCY_COMPARATOR;
    }

    public static Comparator<? super MonetaryAmount> sortValuable(final ExchangeRateProvider provider) {
        return new Comparator<MonetaryAmount>(){

            @Override
            public int compare(MonetaryAmount m1, MonetaryAmount m2) {
                CurrencyConversion conversor = provider.getCurrencyConversion(m1.getCurrency());
                return m1.compareTo((Object)conversor.apply(m2));
            }
        };
    }

    @Deprecated
    public static Comparator<? super MonetaryAmount> sortValiable(ExchangeRateProvider provider) {
        return MonetaryFunctions.sortValuable(provider);
    }

    public static Comparator<? super MonetaryAmount> sortValuableDesc(final ExchangeRateProvider provider) {
        return new Comparator<MonetaryAmount>(){

            @Override
            public int compare(MonetaryAmount o1, MonetaryAmount o2) {
                return MonetaryFunctions.sortValuable(provider).compare((MonetaryAmount)o1, (MonetaryAmount)o2) * -1;
            }
        };
    }

    @Deprecated
    public static Comparator<? super MonetaryAmount> sortValiableDesc(final ExchangeRateProvider provider) {
        return new Comparator<MonetaryAmount>(){

            @Override
            public int compare(MonetaryAmount o1, MonetaryAmount o2) {
                return MonetaryFunctions.sortValuable(provider).compare((MonetaryAmount)o1, (MonetaryAmount)o2) * -1;
            }
        };
    }

    public static Comparator<MonetaryAmount> sortCurrencyUnitDesc() {
        return new Comparator<MonetaryAmount>(){

            @Override
            public int compare(MonetaryAmount o1, MonetaryAmount o2) {
                return MonetaryFunctions.sortCurrencyUnit().compare(o1, o2) * -1;
            }
        };
    }

    public static Comparator<MonetaryAmount> sortNumber() {
        return NUMBER_COMPARATOR;
    }

    public static Comparator<MonetaryAmount> sortNumberDesc() {
        return new Comparator<MonetaryAmount>(){

            @Override
            public int compare(MonetaryAmount o1, MonetaryAmount o2) {
                return MonetaryFunctions.sortNumber().compare(o1, o2) * -1;
            }
        };
    }

    public static MonetaryAmount sum(MonetaryAmount a, MonetaryAmount b) {
        MoneyUtils.checkAmountParameter(Objects.requireNonNull(a), Objects.requireNonNull(b.getCurrency()));
        return a.add(b);
    }

    static MonetaryAmount min(MonetaryAmount a, MonetaryAmount b) {
        MoneyUtils.checkAmountParameter(Objects.requireNonNull(a), Objects.requireNonNull(b.getCurrency()));
        return a.isLessThan(b) ? a : b;
    }

    static MonetaryAmount max(MonetaryAmount a, MonetaryAmount b) {
        MoneyUtils.checkAmountParameter(Objects.requireNonNull(a), Objects.requireNonNull(b.getCurrency()));
        return a.isGreaterThan(b) ? a : b;
    }
}

