/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.spi.ServiceProvider;
import org.javamoney.moneta.internal.OSGIServiceComparator;
import org.javamoney.moneta.spi.PriorityServiceComparator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class OSGIServiceProvider
implements ServiceProvider {
    private static final Logger LOG = Logger.getLogger(OSGIServiceProvider.class.getName());
    private static final OSGIServiceComparator REF_COMPARATOR = new OSGIServiceComparator();
    private BundleContext bundleContext;

    public OSGIServiceProvider(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public boolean isInitialized() {
        return true;
    }

    public int getPriority() {
        return 10;
    }

    public <T> T getService(Class<T> serviceType) {
        LOG.finest("TAMAYA  Loading service: " + serviceType.getName());
        ServiceReference ref = this.bundleContext.getServiceReference(serviceType);
        if (ref != null) {
            return (T)this.bundleContext.getService(ref);
        }
        return null;
    }

    public <T> T create(Class<T> serviceType) {
        LOG.finest("TAMAYA  Creating service: " + serviceType.getName());
        ServiceReference ref = this.bundleContext.getServiceReference(serviceType);
        if (ref != null) {
            try {
                return (T)this.bundleContext.getService(ref).getClass().newInstance();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public <T> List<T> getServices(Class<T> serviceType) {
        LOG.finest("TAMAYA  Loading services: " + serviceType.getName());
        ArrayList refs = new ArrayList();
        ArrayList<Object> services = new ArrayList<Object>(refs.size());
        try {
            refs.addAll(this.bundleContext.getServiceReferences(serviceType, null));
            Collections.sort(refs, REF_COMPARATOR);
            for (ServiceReference ref : refs) {
                Object service = this.bundleContext.getService(ref);
                if (service == null) continue;
                services.add(service);
            }
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        try {
            for (T service : ServiceLoader.load(serviceType)) {
                services.add(service);
            }
            return services;
        }
        catch (Exception e) {
            e.printStackTrace();
            return services;
        }
    }

    public Enumeration<URL> getResources(String resource, ClassLoader cl) throws IOException {
        LOG.finest("TAMAYA  Loading resources: " + resource);
        ArrayList<URL> result = new ArrayList<URL>();
        URL url = this.bundleContext.getBundle().getEntry(resource);
        if (url != null) {
            LOG.finest("TAMAYA  Resource: " + resource + " found in unregistered bundle " + this.bundleContext.getBundle().getSymbolicName());
            result.add(url);
        }
        for (Bundle bundle : this.bundleContext.getBundles()) {
            url = bundle.getEntry(resource);
            if (url == null || result.contains(url)) continue;
            LOG.finest("TAMAYA  Resource: " + resource + " found in registered bundle " + bundle.getSymbolicName());
            result.add(url);
        }
        for (Bundle bundle : this.bundleContext.getBundles()) {
            url = bundle.getEntry(resource);
            if (url == null || result.contains(url)) continue;
            LOG.finest("TAMAYA  Resource: " + resource + " found in unregistered bundle " + bundle.getSymbolicName());
            result.add(url);
        }
        return Collections.enumeration(result);
    }

    public static <T> void registerService(Bundle bundle, Class<T> serviceClass, Class<? extends T> implClass) {
        try {
            LOG.info("Loaded Service Factory (" + serviceClass.getName() + "): " + implClass.getName());
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("version", bundle.getVersion().toString());
            String vendor = (String)bundle.getHeaders().get("Bundle-Vendor");
            props.put("service.vendor", vendor != null ? vendor : "anonymous");
            props.put("service.ranking", String.valueOf(PriorityServiceComparator.getPriority(implClass)));
            JDKUtilServiceFactory factory = new JDKUtilServiceFactory(implClass);
            BundleContext bundleContext = bundle.getBundleContext();
            bundleContext.registerService(serviceClass.getName(), (Object)factory, props);
            LOG.info("Registered Tamaya service class: " + implClass.getName() + "(" + serviceClass.getName() + ")");
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to load service: " + implClass.getName(), e);
        }
    }

    public static <T> void unregisterService(Bundle bundle, Class<T> serviceClass, Class<? extends T> implClass) {
        try {
            LOG.fine("Unloading Service (" + serviceClass.getName() + "): " + implClass.getName());
            ServiceReference ref = bundle.getBundleContext().getServiceReference(implClass);
            if (ref != null) {
                bundle.getBundleContext().ungetService(ref);
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to unload service: " + implClass.getName(), e);
        }
    }

    static class JDKUtilServiceFactory
    implements ServiceFactory {
        private final Class<?> serviceClass;

        public JDKUtilServiceFactory(Class<?> serviceClass) {
            this.serviceClass = serviceClass;
        }

        public Object getService(Bundle bundle, ServiceRegistration registration) {
            try {
                LOG.fine("Creating Service...:" + this.serviceClass.getName());
                return this.serviceClass.newInstance();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IllegalStateException("Failed to create service: " + this.serviceClass.getName(), ex);
            }
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        }
    }
}

