/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.NumberValue;
import javax.money.convert.ConversionContext;
import javax.money.convert.CurrencyConversion;
import javax.money.convert.CurrencyConversionException;
import javax.money.convert.ExchangeRate;
import org.javamoney.moneta.function.MonetaryOperators;

public abstract class AbstractCurrencyConversion
implements CurrencyConversion {
    private final CurrencyUnit termCurrency;
    private final ConversionContext conversionContext;
    public static final String KEY_SCALE = "exchangeRateScale";

    public AbstractCurrencyConversion(CurrencyUnit termCurrency, ConversionContext conversionContext) {
        Objects.requireNonNull(termCurrency);
        Objects.requireNonNull(conversionContext);
        this.termCurrency = termCurrency;
        this.conversionContext = conversionContext;
    }

    public CurrencyUnit getCurrency() {
        return this.termCurrency;
    }

    public ConversionContext getContext() {
        return this.conversionContext;
    }

    public abstract ExchangeRate getExchangeRate(MonetaryAmount var1);

    public abstract CurrencyConversion with(ConversionContext var1);

    public MonetaryAmount apply(MonetaryAmount amount) {
        if (this.termCurrency.equals(Objects.requireNonNull(amount).getCurrency())) {
            return amount;
        }
        ExchangeRate rate = this.getExchangeRate(amount);
        if (rate == null || !amount.getCurrency().equals(rate.getBaseCurrency())) {
            throw new CurrencyConversionException(amount.getCurrency(), this.termCurrency, this.conversionContext);
        }
        NumberValue factor = rate.getFactor();
        factor = this.roundFactor(amount, factor);
        Integer scale = (Integer)rate.getContext().get(KEY_SCALE, Integer.class);
        if (scale == null || scale < 0) {
            return amount.multiply((Number)factor).getFactory().setCurrency(rate.getCurrency()).create();
        }
        return amount.multiply((Number)factor).getFactory().setCurrency(rate.getCurrency()).create().with(MonetaryOperators.rounding(scale));
    }

    protected NumberValue roundFactor(MonetaryAmount amount, NumberValue factor) {
        if (amount.getContext().getMaxScale() > 0) {
            MathContext mathContext = (MathContext)amount.getContext().get(MathContext.class);
            if (mathContext == null) {
                RoundingMode roundingMode;
                int scale = factor.getScale();
                if (factor.getScale() > amount.getContext().getMaxScale()) {
                    scale = amount.getContext().getMaxScale();
                }
                if ((roundingMode = (RoundingMode)((Object)amount.getContext().get(RoundingMode.class))) == null) {
                    roundingMode = RoundingMode.HALF_EVEN;
                }
                mathContext = new MathContext(scale, roundingMode);
            }
            return factor.round(mathContext);
        }
        return factor;
    }

    public String toString() {
        return this.getClass().getName() + " [MonetaryAmount -> MonetaryAmount" + ']';
    }
}

