/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.money.CurrencyQuery;
import javax.money.CurrencyUnit;
import org.javamoney.moneta.spi.base.BaseCurrencyProviderSpi;

public class ConfigurableCurrencyUnitProvider
extends BaseCurrencyProviderSpi {
    private static final Map<String, CurrencyUnit> currencyUnits = new ConcurrentHashMap<String, CurrencyUnit>();
    private static final Map<Integer, CurrencyUnit> currencyUnitsByNumericCode = new ConcurrentHashMap<Integer, CurrencyUnit>();
    private static final Map<Locale, CurrencyUnit> currencyUnitsByLocale = new ConcurrentHashMap<Locale, CurrencyUnit>();

    public Set<CurrencyUnit> getCurrencies(CurrencyQuery currencyQuery) {
        HashSet<CurrencyUnit> result = new HashSet<CurrencyUnit>(currencyUnits.size());
        if (!currencyQuery.getCurrencyCodes().isEmpty()) {
            for (String code : currencyQuery.getCurrencyCodes()) {
                CurrencyUnit cu = currencyUnits.get(code);
                if (cu == null) continue;
                result.add(cu);
            }
            return result;
        }
        if (!currencyQuery.getCountries().isEmpty()) {
            for (Locale locale : currencyQuery.getCountries()) {
                CurrencyUnit cu = currencyUnitsByLocale.get(locale);
                if (cu == null) continue;
                result.add(cu);
            }
            return result;
        }
        if (!currencyQuery.getNumericCodes().isEmpty()) {
            for (Integer numericCode : currencyQuery.getNumericCodes()) {
                CurrencyUnit cu = currencyUnitsByNumericCode.get(numericCode);
                if (cu == null) continue;
                result.add(cu);
            }
            return result;
        }
        result.addAll(currencyUnits.values());
        return result;
    }

    public static CurrencyUnit registerCurrencyUnit(CurrencyUnit currencyUnit) {
        Objects.requireNonNull(currencyUnit);
        CurrencyUnit registered = currencyUnits.put(currencyUnit.getCurrencyCode(), currencyUnit);
        int numericCode = currencyUnit.getNumericCode();
        if (numericCode != -1) {
            currencyUnitsByNumericCode.put(numericCode, currencyUnit);
        }
        return registered;
    }

    public static CurrencyUnit registerCurrencyUnit(CurrencyUnit currencyUnit, Locale locale) {
        Objects.requireNonNull(locale);
        Objects.requireNonNull(currencyUnit);
        return currencyUnitsByLocale.put(locale, currencyUnit);
    }

    public static CurrencyUnit removeCurrencyUnit(String currencyCode) {
        int numericCode;
        Objects.requireNonNull(currencyCode);
        CurrencyUnit removed = currencyUnits.remove(currencyCode);
        if (removed != null && (numericCode = removed.getNumericCode()) != -1) {
            currencyUnitsByNumericCode.remove(numericCode);
        }
        return removed;
    }

    public static CurrencyUnit removeCurrencyUnit(Locale locale) {
        Objects.requireNonNull(locale);
        return currencyUnitsByLocale.remove(locale);
    }

    public String toString() {
        return "ConfigurableCurrencyUnitProvider [currencyUnits=" + currencyUnits + ", currencyUnitsByNumericCode=" + currencyUnitsByNumericCode + ", currencyUnitsByLocale=" + currencyUnitsByLocale + ']';
    }
}

