/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryRounding;
import javax.money.RoundingContext;
import javax.money.RoundingContextBuilder;

final class DefaultRounding
implements MonetaryRounding,
Serializable {
    private static final String SCALE_KEY = "scale";
    private static final String PROVCLASS_KEY = "providerClass";
    private final RoundingContext context;

    DefaultRounding(int scale, RoundingMode roundingMode) {
        Objects.requireNonNull(roundingMode, "RoundingMode required.");
        if (scale < 0) {
            scale = 0;
        }
        RoundingContextBuilder b = (RoundingContextBuilder)((RoundingContextBuilder)RoundingContextBuilder.of((String)"default", (String)"default").set(PROVCLASS_KEY, (Object)this.getClass().getName())).set(SCALE_KEY, scale);
        this.context = ((RoundingContextBuilder)b.set((Object)roundingMode)).build();
    }

    DefaultRounding(CurrencyUnit currency, RoundingMode roundingMode) {
        this(currency.getDefaultFractionDigits(), roundingMode);
    }

    public MonetaryAmount apply(MonetaryAmount amount) {
        return amount.getFactory().setCurrency(amount.getCurrency()).setNumber((Number)((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)).setScale((int)this.context.getInt(SCALE_KEY), (RoundingMode)((Object)this.context.get(RoundingMode.class)))).create();
    }

    public RoundingContext getRoundingContext() {
        return this.context;
    }
}

