/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi.base;

import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.convert.ConversionQuery;
import javax.money.convert.ConversionQueryBuilder;
import javax.money.convert.CurrencyConversion;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ExchangeRateProvider;

public abstract class BaseExchangeRateProvider
implements ExchangeRateProvider {
    public boolean isAvailable(ConversionQuery conversionQuery) {
        Objects.requireNonNull(conversionQuery);
        try {
            return conversionQuery.getProviderNames().isEmpty() || conversionQuery.getProviderNames().contains(this.getContext().getProviderName());
        }
        catch (Exception e) {
            return false;
        }
    }

    public ExchangeRate getExchangeRate(CurrencyUnit base, CurrencyUnit term) {
        Objects.requireNonNull(base, "Base Currency is null");
        Objects.requireNonNull(term, "Term Currency is null");
        return this.getExchangeRate(ConversionQueryBuilder.of().setBaseCurrency(base).setTermCurrency(term).build());
    }

    public CurrencyConversion getCurrencyConversion(CurrencyUnit term) {
        return this.getCurrencyConversion(ConversionQueryBuilder.of().setTermCurrency(term).build());
    }

    public boolean isAvailable(CurrencyUnit base, CurrencyUnit term) {
        return this.isAvailable(ConversionQueryBuilder.of().setBaseCurrency(base).setTermCurrency(term).build());
    }

    public boolean isAvailable(String baseCode, String termCode) {
        return this.isAvailable(Monetary.getCurrency((String)baseCode, (String[])new String[0]), Monetary.getCurrency((String)termCode, (String[])new String[0]));
    }

    public ExchangeRate getExchangeRate(String baseCode, String termCode) {
        return this.getExchangeRate(Monetary.getCurrency((String)baseCode, (String[])new String[0]), Monetary.getCurrency((String)termCode, (String[])new String[0]));
    }

    public ExchangeRate getReversed(ExchangeRate rate) {
        ConversionQuery reverseQuery = rate.getContext().toQueryBuilder().setBaseCurrency(rate.getCurrency()).setTermCurrency(rate.getBaseCurrency()).build();
        if (this.isAvailable(reverseQuery)) {
            return this.getExchangeRate(reverseQuery);
        }
        return null;
    }

    public CurrencyConversion getCurrencyConversion(String termCode) {
        return this.getCurrencyConversion(Monetary.getCurrency((String)termCode, (String[])new String[0]));
    }
}

