/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryException;
import javax.money.convert.ConversionQuery;
import javax.money.convert.ConversionQueryBuilder;
import javax.money.convert.CurrencyConversion;
import javax.money.convert.ExchangeRateProvider;
import javax.money.spi.MonetaryConversionsSingletonSpi;

public abstract class BaseMonetaryConversionsSingletonSpi
implements MonetaryConversionsSingletonSpi {
    public boolean isExchangeRateProviderAvailable(ConversionQuery conversionQuery) {
        try {
            return this.getExchangeRateProvider(conversionQuery) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isConversionAvailable(ConversionQuery conversionQuery) {
        try {
            return this.getConversion(conversionQuery) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isConversionAvailable(CurrencyUnit termCurrency, String ... providers) {
        return this.isConversionAvailable(((ConversionQueryBuilder)ConversionQueryBuilder.of().setTermCurrency(termCurrency).setProviderNames(providers)).build());
    }

    public List<ExchangeRateProvider> getExchangeRateProviders(String ... providers) {
        ArrayList<ExchangeRateProvider> provInstances = new ArrayList<ExchangeRateProvider>();
        Collection<String> providerNames = Arrays.asList(providers);
        if (providerNames.isEmpty()) {
            providerNames = this.getProviderNames();
        }
        for (String provName : providerNames) {
            ExchangeRateProvider provider = this.getExchangeRateProvider(provName);
            if (provider == null) {
                throw new MonetaryException("Unsupported conversion/rate provider: " + provName);
            }
            provInstances.add(provider);
        }
        return provInstances;
    }

    public ExchangeRateProvider getExchangeRateProvider(String ... providers) {
        return this.getExchangeRateProvider(((ConversionQueryBuilder)ConversionQueryBuilder.of().setProviderNames(providers)).build());
    }

    public CurrencyConversion getConversion(ConversionQuery conversionQuery) {
        return this.getExchangeRateProvider(conversionQuery).getCurrencyConversion(Objects.requireNonNull(conversionQuery.getCurrency(), "Terminating Currency is required."));
    }

    public CurrencyConversion getConversion(CurrencyUnit termCurrency, String ... providers) {
        return this.getConversion(((ConversionQueryBuilder)ConversionQueryBuilder.of().setTermCurrency(termCurrency).setProviderNames(providers)).build());
    }
}

