/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi.base;

import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.money.CurrencyQuery;
import javax.money.CurrencyQueryBuilder;
import javax.money.CurrencyUnit;
import javax.money.MonetaryException;
import javax.money.UnknownCurrencyException;
import javax.money.spi.MonetaryCurrenciesSingletonSpi;

public abstract class BaseMonetaryCurrenciesSingletonSpi
implements MonetaryCurrenciesSingletonSpi {
    public CurrencyUnit getCurrency(String currencyCode, String ... providers) {
        Objects.requireNonNull(currencyCode, "Currency Code may not be null");
        Set found = this.getCurrencies(((CurrencyQueryBuilder)CurrencyQueryBuilder.of().setCurrencyCodes(new String[]{currencyCode}).setProviderNames(providers)).build());
        if (found.isEmpty()) {
            throw new UnknownCurrencyException(currencyCode);
        }
        if (found.size() > 1) {
            throw new MonetaryException("Ambiguous CurrencyUnit for code: " + currencyCode + ": " + found);
        }
        return (CurrencyUnit)found.iterator().next();
    }

    public CurrencyUnit getCurrency(Locale country, String ... providers) {
        Set found = this.getCurrencies(((CurrencyQueryBuilder)CurrencyQueryBuilder.of().setCountries(new Locale[]{country}).setProviderNames(providers)).build());
        if (found.isEmpty()) {
            throw new MonetaryException("No currency unit found for locale: " + country);
        }
        if (found.size() > 1) {
            throw new MonetaryException("Ambiguous CurrencyUnit for locale: " + country + ": " + found);
        }
        return (CurrencyUnit)found.iterator().next();
    }

    public Set<CurrencyUnit> getCurrencies(Locale locale, String ... providers) {
        return this.getCurrencies(((CurrencyQueryBuilder)CurrencyQueryBuilder.of().setCountries(new Locale[]{locale}).setProviderNames(providers)).build());
    }

    public boolean isCurrencyAvailable(String code, String ... providers) {
        return !this.getCurrencies(((CurrencyQueryBuilder)CurrencyQueryBuilder.of().setCurrencyCodes(new String[]{code}).setProviderNames(providers)).build()).isEmpty();
    }

    public boolean isCurrencyAvailable(Locale locale, String ... providers) {
        return !this.getCurrencies(((CurrencyQueryBuilder)CurrencyQueryBuilder.of().setCountries(new Locale[]{locale}).setProviderNames(providers)).build()).isEmpty();
    }

    public Set<CurrencyUnit> getCurrencies(String ... providers) {
        return this.getCurrencies(((CurrencyQueryBuilder)CurrencyQueryBuilder.of().setProviderNames(providers)).build());
    }

    public CurrencyUnit getCurrency(CurrencyQuery query) {
        Set currencies = this.getCurrencies(query);
        if (currencies.isEmpty()) {
            return null;
        }
        if (currencies.size() == 1) {
            return (CurrencyUnit)currencies.iterator().next();
        }
        throw new MonetaryException("Ambiguous request for CurrencyUnit: " + query + ", found: " + currencies);
    }
}

