/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi.base;

import java.util.Collection;
import javax.money.CurrencyUnit;
import javax.money.MonetaryException;
import javax.money.MonetaryRounding;
import javax.money.RoundingQuery;
import javax.money.RoundingQueryBuilder;
import javax.money.spi.MonetaryRoundingsSingletonSpi;

public abstract class BaseMonetaryRoundingsSingletonSpi
implements MonetaryRoundingsSingletonSpi {
    public MonetaryRounding getRounding(CurrencyUnit currencyUnit, String ... providers) {
        MonetaryRounding op = this.getRounding(((RoundingQueryBuilder)RoundingQueryBuilder.of().setProviderNames(providers)).setCurrency(currencyUnit).build());
        if (op == null) {
            throw new MonetaryException("No rounding provided for CurrencyUnit: " + currencyUnit.getCurrencyCode());
        }
        return op;
    }

    public MonetaryRounding getRounding(String roundingName, String ... providers) {
        MonetaryRounding op = this.getRounding(((RoundingQueryBuilder)RoundingQueryBuilder.of().setProviderNames(providers)).setRoundingName(roundingName).build());
        if (op == null) {
            throw new MonetaryException("No rounding provided with rounding name: " + roundingName);
        }
        return op;
    }

    public MonetaryRounding getRounding(RoundingQuery query) {
        Collection roundings = this.getRoundings(query);
        if (roundings.isEmpty()) {
            return null;
        }
        return (MonetaryRounding)roundings.iterator().next();
    }

    public boolean isRoundingAvailable(RoundingQuery query) {
        return !this.getRoundings(query).isEmpty();
    }

    public boolean isRoundingAvailable(String roundingId, String ... providers) {
        return this.isRoundingAvailable(((RoundingQueryBuilder)RoundingQueryBuilder.of().setProviderNames(providers)).setRoundingName(roundingId).build());
    }

    public boolean isRoundingAvailable(CurrencyUnit currencyUnit, String ... providers) {
        return this.isRoundingAvailable(((RoundingQueryBuilder)RoundingQueryBuilder.of().setProviderNames(providers)).setCurrency(currencyUnit).build());
    }
}

