/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi.loader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.spi.Bootstrap;
import org.javamoney.moneta.spi.LoadDataInformation;
import org.javamoney.moneta.spi.LoadDataInformationBuilder;
import org.javamoney.moneta.spi.LoaderService;
import org.javamoney.moneta.spi.loader.DaemonThreadFactory;
import org.javamoney.moneta.spi.loader.DefaultLoaderListener;
import org.javamoney.moneta.spi.loader.DefaultLoaderServiceFacade;
import org.javamoney.moneta.spi.loader.DefaultResourceCache;
import org.javamoney.moneta.spi.loader.LoadableResource;
import org.javamoney.moneta.spi.loader.LoadableResourceBuilder;
import org.javamoney.moneta.spi.loader.LoaderConfigurator;
import org.javamoney.moneta.spi.loader.ResourceCache;

public class DefaultLoaderService
implements LoaderService {
    private static final Logger LOG = Logger.getLogger(DefaultLoaderService.class.getName());
    private final Map<String, LoadableResource> resources = new ConcurrentHashMap<String, LoadableResource>();
    private final DefaultLoaderListener listener = new DefaultLoaderListener();
    private static final ResourceCache CACHE = DefaultLoaderService.loadResourceCache();
    private final ExecutorService executors = Executors.newCachedThreadPool(DaemonThreadFactory.INSTANCE);
    private DefaultLoaderServiceFacade defaultLoaderServiceFacade;
    private volatile Timer timer;

    public DefaultLoaderService() {
        this.initialize();
    }

    @Deprecated
    protected void initialize() {
        Timer oldTimer = this.timer;
        this.timer = new Timer();
        if (oldTimer != null) {
            oldTimer.cancel();
        }
        LoaderConfigurator configurator = new LoaderConfigurator(this);
        this.defaultLoaderServiceFacade = new DefaultLoaderServiceFacade(this.timer, this.listener, this.resources);
        configurator.load();
    }

    private static ResourceCache loadResourceCache() {
        try {
            ResourceCache cache = (ResourceCache)Bootstrap.getService(ResourceCache.class);
            if (cache == null) {
                cache = new DefaultResourceCache();
            }
            return cache;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error loading ResourceCache instance.", e);
            return new DefaultResourceCache();
        }
    }

    static ResourceCache getResourceCache() {
        return CACHE;
    }

    public void unload(String resourceId) {
        LoadableResource res = this.resources.get(resourceId);
        if (res != null) {
            res.unload();
        }
    }

    @Override
    public void registerData(LoadDataInformation loadDataInformation) {
        if (this.resources.containsKey(loadDataInformation.getResourceId())) {
            throw new IllegalArgumentException("Resource : " + loadDataInformation.getResourceId() + " already registered.");
        }
        LoadableResource resource = new LoadableResourceBuilder().withCache(CACHE).withLoadDataInformation(loadDataInformation).build();
        this.resources.put(loadDataInformation.getResourceId(), resource);
        if (loadDataInformation.getLoaderListener() != null) {
            this.addLoaderListener(loadDataInformation.getLoaderListener(), loadDataInformation.getResourceId());
        }
        if (loadDataInformation.isStartRemote()) {
            this.defaultLoaderServiceFacade.loadDataRemote(loadDataInformation.getResourceId(), this.resources);
        }
        switch (loadDataInformation.getUpdatePolicy()) {
            case NEVER: {
                this.loadDataLocal(loadDataInformation.getResourceId());
                break;
            }
            case ONSTARTUP: {
                this.loadDataAsync(loadDataInformation.getResourceId());
                break;
            }
            case SCHEDULED: {
                this.defaultLoaderServiceFacade.scheduledData(resource);
                break;
            }
        }
    }

    @Override
    public void registerAndLoadData(LoadDataInformation loadDataInformation) {
        this.registerData(loadDataInformation);
        this.loadData(loadDataInformation.getResourceId());
    }

    @Override
    public void registerAndLoadData(String resourceId, LoaderService.UpdatePolicy updatePolicy, Map<String, String> properties, LoaderService.LoaderListener loaderListener, URI backupResource, URI ... resourceLocations) {
        this.registerAndLoadData(new LoadDataInformationBuilder().withResourceId(resourceId).withUpdatePolicy(updatePolicy).withProperties(properties).withLoaderListener(loaderListener).withBackupResource(backupResource).withResourceLocations(resourceLocations).build());
    }

    @Override
    public void registerData(String resourceId, LoaderService.UpdatePolicy updatePolicy, Map<String, String> properties, LoaderService.LoaderListener loaderListener, URI backupResource, URI ... resourceLocations) {
        if (this.resources.containsKey(resourceId)) {
            throw new IllegalArgumentException("Resource : " + resourceId + " already registered.");
        }
        LoadDataInformation loadInfo = new LoadDataInformationBuilder().withResourceId(resourceId).withUpdatePolicy(updatePolicy).withProperties(properties).withLoaderListener(loaderListener).withBackupResource(backupResource).withResourceLocations(resourceLocations).build();
        LoadableResource resource = new LoadableResourceBuilder().withCache(CACHE).withLoadDataInformation(loadInfo).build();
        this.resources.put(loadInfo.getResourceId(), resource);
        if (loadInfo.getLoaderListener() != null) {
            this.addLoaderListener(loadInfo.getLoaderListener(), loadInfo.getResourceId());
        }
        switch (loadInfo.getUpdatePolicy()) {
            case SCHEDULED: {
                this.defaultLoaderServiceFacade.scheduledData(resource);
                break;
            }
        }
        this.loadData(resourceId);
    }

    @Override
    public Map<String, String> getUpdateConfiguration(String resourceId) {
        LoadableResource load = this.resources.get(resourceId);
        if (load != null) {
            return load.getProperties();
        }
        return null;
    }

    @Override
    public boolean isResourceRegistered(String dataId) {
        return this.resources.containsKey(dataId);
    }

    @Override
    public Set<String> getResourceIds() {
        return this.resources.keySet();
    }

    @Override
    public InputStream getData(String resourceId) throws IOException {
        LoadableResource load = this.resources.get(resourceId);
        if (load != null) {
            load.getDataStream();
        }
        throw new IllegalArgumentException("No such resource: " + resourceId);
    }

    @Override
    public boolean loadData(String resourceId) {
        return this.defaultLoaderServiceFacade.loadData(resourceId, this.resources);
    }

    @Override
    public Future<Boolean> loadDataAsync(final String resourceId) {
        return this.executors.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return DefaultLoaderService.this.defaultLoaderServiceFacade.loadData(resourceId, DefaultLoaderService.this.resources);
            }
        });
    }

    @Override
    public boolean loadDataLocal(String resourceId) {
        return this.defaultLoaderServiceFacade.loadDataLocal(resourceId);
    }

    @Override
    public void resetData(String resourceId) throws IOException {
        LoadableResource load = this.resources.get(resourceId);
        if (load == null) {
            throw new IllegalArgumentException("No such resource: " + resourceId);
        }
        if (load.resetToFallback()) {
            this.listener.trigger(resourceId, load.getDataStream());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLoaderListener(LoaderService.LoaderListener l, String ... dataIds) {
        if (dataIds.length == 0) {
            List<LoaderService.LoaderListener> listeners;
            List<LoaderService.LoaderListener> list = listeners = this.listener.getListeners("");
            synchronized (list) {
                listeners.add(l);
            }
        } else {
            for (String dataId : dataIds) {
                List<LoaderService.LoaderListener> listeners;
                List<LoaderService.LoaderListener> list = listeners = this.listener.getListeners(dataId);
                synchronized (list) {
                    listeners.add(l);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLoaderListener(LoaderService.LoaderListener l, String ... dataIds) {
        if (dataIds.length == 0) {
            List<LoaderService.LoaderListener> listeners;
            List<LoaderService.LoaderListener> list = listeners = this.listener.getListeners("");
            synchronized (list) {
                listeners.remove(l);
            }
        } else {
            for (String dataId : dataIds) {
                List<LoaderService.LoaderListener> listeners;
                List<LoaderService.LoaderListener> list = listeners = this.listener.getListeners(dataId);
                synchronized (list) {
                    listeners.remove(l);
                }
            }
        }
    }

    @Override
    public LoaderService.UpdatePolicy getUpdatePolicy(String resourceId) {
        LoadableResource load = this.resources.get(resourceId);
        if (load == null) {
            throw new IllegalArgumentException("No such resource: " + resourceId);
        }
        return load.getUpdatePolicy();
    }

    public String toString() {
        return "DefaultLoaderService [resources=" + this.resources + ']';
    }
}

