/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi.loader;

import java.util.Map;
import java.util.Timer;
import org.javamoney.moneta.spi.loader.DefaultLoaderListener;
import org.javamoney.moneta.spi.loader.LoadDataLoaderService;
import org.javamoney.moneta.spi.loader.LoadDataLocalLoaderService;
import org.javamoney.moneta.spi.loader.LoadRemoteDataLoaderService;
import org.javamoney.moneta.spi.loader.LoadableResource;
import org.javamoney.moneta.spi.loader.ScheduledDataLoaderService;

class DefaultLoaderServiceFacade {
    private final ScheduledDataLoaderService scheduledDataLoaderService;
    private final LoadDataLoaderService loadDataLoaderService;
    private final LoadDataLocalLoaderService loadDataLocalLoaderService;
    private final LoadRemoteDataLoaderService loadRemoteDataLoaderService;

    DefaultLoaderServiceFacade(Timer timer, DefaultLoaderListener listener, Map<String, LoadableResource> resources) {
        this.scheduledDataLoaderService = new ScheduledDataLoaderService(timer, listener);
        this.loadDataLoaderService = new LoadDataLoaderService(listener);
        this.loadDataLocalLoaderService = new LoadDataLocalLoaderService(resources, listener);
        this.loadRemoteDataLoaderService = new LoadRemoteDataLoaderService(listener);
    }

    public void scheduledData(LoadableResource load) {
        this.scheduledDataLoaderService.execute(load);
    }

    public boolean loadData(String resourceId, Map<String, LoadableResource> resources) {
        return this.loadDataLoaderService.execute(resourceId, resources);
    }

    public boolean loadDataLocal(String resourceId) {
        return this.loadDataLocalLoaderService.execute(resourceId);
    }

    public boolean loadDataRemote(String resourceId, Map<String, LoadableResource> resources) {
        return this.loadRemoteDataLoaderService.execute(resourceId, resources);
    }

    public String toString() {
        String sb = DefaultLoaderServiceFacade.class.getName() + '{' + " scheduledDataLoaderService: " + this.scheduledDataLoaderService + ',' + " asyncLoaderService: " + this.loadDataLoaderService + ',' + " loadDataLocalLoaderService: " + this.loadDataLocalLoaderService + ',';
        return sb;
    }
}

