/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta;

import java.util.Locale;
import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryException;
import org.javamoney.moneta.internal.ConfigurableCurrencyUnitProvider;

public final class BuildableCurrencyUnit
implements CurrencyUnit,
Comparable<CurrencyUnit> {
    private String currencyCode;
    private int numericCode;
    private int defaultFractionDigits;

    private BuildableCurrencyUnit(Builder builder) {
        Objects.requireNonNull(builder.currencyCode, "currencyCode required");
        if (builder.numericCode < -1) {
            throw new MonetaryException("numericCode must be >= -1");
        }
        if (builder.defaultFractionDigits < 0) {
            throw new MonetaryException("defaultFractionDigits must be >= 0");
        }
        this.defaultFractionDigits = builder.defaultFractionDigits;
        this.numericCode = builder.numericCode;
        this.currencyCode = builder.currencyCode;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public int getNumericCode() {
        return this.numericCode;
    }

    public int getDefaultFractionDigits() {
        return this.defaultFractionDigits;
    }

    @Override
    public int compareTo(CurrencyUnit o) {
        return this.currencyCode.compareTo(o.getCurrencyCode());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.currencyCode == null ? 0 : this.currencyCode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BuildableCurrencyUnit other = (BuildableCurrencyUnit)obj;
        return !(this.currencyCode == null ? other.currencyCode != null : !this.currencyCode.equals(other.currencyCode));
    }

    public String toString() {
        return "BuildableCurrencyUnit [currencyCode=" + this.currencyCode + ", numericCode=" + this.numericCode + ", defaultFractionDigits=" + this.defaultFractionDigits + "]";
    }

    public static final class Builder {
        private String currencyCode;
        private int numericCode = -1;
        private int defaultFractionDigits = 2;

        public Builder(String currencyCode) {
            Objects.requireNonNull(currencyCode, "currencyCode required");
            this.currencyCode = currencyCode;
        }

        public Builder setCurrencyCode(String currencyCode) {
            Objects.requireNonNull(currencyCode, "currencyCode required");
            this.currencyCode = currencyCode;
            return this;
        }

        public Builder setNumericCode(int numericCode) {
            if (numericCode < -1) {
                throw new IllegalArgumentException("numericCode must be >= -1");
            }
            this.numericCode = numericCode;
            return this;
        }

        public Builder setDefaultFractionDigits(int defaultFractionDigits) {
            if (defaultFractionDigits < 0) {
                throw new IllegalArgumentException("defaultFractionDigits must be >= 0");
            }
            this.defaultFractionDigits = defaultFractionDigits;
            return this;
        }

        public BuildableCurrencyUnit create() {
            return this.create(false);
        }

        public BuildableCurrencyUnit create(boolean register) {
            BuildableCurrencyUnit cu = new BuildableCurrencyUnit(this);
            if (register) {
                ConfigurableCurrencyUnitProvider.registerCurrencyUnit(cu);
            }
            return cu;
        }

        public BuildableCurrencyUnit create(boolean register, Locale locale) {
            BuildableCurrencyUnit cu = new BuildableCurrencyUnit(this);
            if (register) {
                ConfigurableCurrencyUnitProvider.registerCurrencyUnit(cu);
                ConfigurableCurrencyUnitProvider.registerCurrencyUnit(cu, locale);
            }
            return cu;
        }
    }
}

