/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryContext;
import javax.money.MonetaryCurrencies;
import javax.money.MonetaryException;
import javax.money.MonetaryOperator;
import javax.money.MonetaryQuery;
import javax.money.NumberValue;
import org.javamoney.moneta.Money;
import org.javamoney.moneta.internal.FastMoneyAmountFactory;
import org.javamoney.moneta.spi.AbstractMoney;
import org.javamoney.moneta.spi.DefaultNumberValue;

public final class FastMoney
extends AbstractMoney
implements Comparable<MonetaryAmount>,
Serializable {
    private static final long serialVersionUID = 1L;
    private long number;
    private transient NumberValue numberValue;
    private static final int SCALE = 5;
    private static final MonetaryContext MONETARY_CONTEXT = new MonetaryContext.Builder(FastMoney.class).setMaxScale(5).setFixedScale(true).setPrecision(String.valueOf(Integer.MAX_VALUE).length()).create();

    private FastMoney() {
    }

    private FastMoney(CurrencyUnit currency, Number number) {
        super(currency, MONETARY_CONTEXT);
        Objects.requireNonNull(number, "Number is required.");
        this.number = this.getInternalNumber(number);
        this.numberValue = new DefaultNumberValue(number);
    }

    private FastMoney(CurrencyUnit currency, NumberValue numberBinding) {
        super(currency, MONETARY_CONTEXT);
        Objects.requireNonNull(numberBinding, "Number is required.");
        this.number = this.getInternalNumber(numberBinding.numberValue(BigDecimal.class));
    }

    private long getInternalNumber(Number number) {
        BigDecimal bd = FastMoney.getBigDecimal(number);
        return bd.movePointRight(5).longValue();
    }

    private FastMoney(CurrencyUnit currency, long number) {
        super(currency, MONETARY_CONTEXT);
        Objects.requireNonNull(currency, "Currency is required.");
        this.currency = currency;
        this.number = number;
    }

    public static FastMoney of(CurrencyUnit currency, NumberValue numberBinding) {
        return new FastMoney(currency, numberBinding);
    }

    public static FastMoney of(CurrencyUnit currency, Number number) {
        return new FastMoney(currency, number);
    }

    public static FastMoney of(String currencyCode, Number number) {
        CurrencyUnit currency = MonetaryCurrencies.getCurrency((String)currencyCode);
        return FastMoney.of(currency, number);
    }

    @Override
    public int compareTo(MonetaryAmount o) {
        int compare = this.getCurrency().getCurrencyCode().compareTo(o.getCurrency().getCurrencyCode());
        if (compare == 0) {
            compare = ((BigDecimal)this.getNumber().numberValue(BigDecimal.class)).compareTo((BigDecimal)o.getNumber().numberValue(BigDecimal.class));
        }
        return compare;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.currency == null ? 0 : this.currency.hashCode());
        result = 31 * result + (int)this.number;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FastMoney other = (FastMoney)obj;
        if (this.currency == null ? other.getCurrency() != null : !this.currency.equals(other.getCurrency())) {
            return false;
        }
        return this.number == other.number;
    }

    @Override
    public CurrencyUnit getCurrency() {
        return this.currency;
    }

    public FastMoney abs() {
        if (this.isPositiveOrZero()) {
            return this;
        }
        return this.negate();
    }

    public FastMoney add(MonetaryAmount amount) {
        this.checkAmountParameter(amount);
        return new FastMoney(this.getCurrency(), this.number + this.getInternalNumber((Number)amount.getNumber()));
    }

    public FastMoney divide(Number divisor) {
        this.checkNumber(divisor);
        return new FastMoney(this.getCurrency(), Math.round((double)this.number / divisor.doubleValue()));
    }

    public FastMoney[] divideAndRemainder(Number divisor) {
        this.checkNumber(divisor);
        BigDecimal div = FastMoney.getBigDecimal(divisor);
        BigDecimal[] res = this.getBigDecimal().divideAndRemainder(div);
        return new FastMoney[]{new FastMoney(this.getCurrency(), res[0]), new FastMoney(this.getCurrency(), res[1])};
    }

    public FastMoney divideToIntegralValue(Number divisor) {
        this.checkNumber(divisor);
        BigDecimal div = FastMoney.getBigDecimal(divisor);
        return new FastMoney(this.getCurrency(), this.getBigDecimal().divideToIntegralValue(div));
    }

    public FastMoney multiply(Number multiplicand) {
        this.checkNumber(multiplicand);
        double multiplicandNum = multiplicand.doubleValue();
        return new FastMoney(this.getCurrency(), Math.round((double)this.number * multiplicandNum));
    }

    public FastMoney negate() {
        return new FastMoney(this.getCurrency(), this.number * -1L);
    }

    public FastMoney plus() {
        if (this.number >= 0L) {
            return this;
        }
        return new FastMoney(this.getCurrency(), this.number * -1L);
    }

    public FastMoney subtract(MonetaryAmount subtrahend) {
        this.checkAmountParameter(subtrahend);
        if (subtrahend.isZero()) {
            return this;
        }
        return new FastMoney(this.getCurrency(), this.number - this.getInternalNumber((Number)subtrahend.getNumber()));
    }

    public FastMoney remainder(Number divisor) {
        this.checkNumber(divisor);
        return new FastMoney(this.getCurrency(), this.number % this.getInternalNumber(divisor));
    }

    public FastMoney scaleByPowerOfTen(int n) {
        return new FastMoney(this.getCurrency(), this.getBigDecimal().scaleByPowerOfTen(n));
    }

    public boolean isZero() {
        return this.number == 0L;
    }

    public boolean isPositive() {
        return this.number > 0L;
    }

    public boolean isPositiveOrZero() {
        return this.number >= 0L;
    }

    public boolean isNegative() {
        return this.number < 0L;
    }

    public boolean isNegativeOrZero() {
        return this.number <= 0L;
    }

    public int getScale() {
        return 5;
    }

    public int getPrecision() {
        return ((BigDecimal)this.getNumber().numberValue(BigDecimal.class)).precision();
    }

    public int signum() {
        if (this.number < 0L) {
            return -1;
        }
        if (this.number == 0L) {
            return 0;
        }
        return 1;
    }

    public boolean isLessThan(MonetaryAmount amount) {
        this.checkAmountParameter(amount);
        return this.number < this.getInternalNumber((Number)amount.getNumber());
    }

    public boolean isLessThan(Number number) {
        this.checkNumber(number);
        return this.number < this.getInternalNumber(number);
    }

    public boolean isLessThanOrEqualTo(MonetaryAmount amount) {
        this.checkAmountParameter(amount);
        return this.number <= this.getInternalNumber((Number)amount.getNumber());
    }

    public boolean isLessThanOrEqualTo(Number number) {
        this.checkNumber(number);
        return this.number <= this.getInternalNumber(number);
    }

    public boolean isGreaterThan(MonetaryAmount amount) {
        this.checkAmountParameter(amount);
        return this.number > this.getInternalNumber((Number)amount.getNumber());
    }

    public boolean isGreaterThan(Number number) {
        this.checkNumber(number);
        return this.number > this.getInternalNumber(number);
    }

    public boolean isGreaterThanOrEqualTo(MonetaryAmount amount) {
        this.checkAmountParameter(amount);
        return this.number >= this.getInternalNumber((Number)amount.getNumber());
    }

    public boolean isGreaterThanOrEqualTo(Number number) {
        this.checkNumber(number);
        return this.number >= this.getInternalNumber(number);
    }

    public boolean isEqualTo(MonetaryAmount amount) {
        this.checkAmountParameter(amount);
        return this.number == this.getInternalNumber((Number)amount.getNumber());
    }

    public boolean hasSameNumberAs(Number number) {
        this.checkNumber(number);
        return this.number == this.getInternalNumber(number);
    }

    public boolean isNotEqualTo(MonetaryAmount amount) {
        this.checkAmountParameter(amount);
        return this.number != this.getInternalNumber((Number)amount.getNumber());
    }

    public boolean isNotEqualTo(Number number) {
        this.checkNumber(number);
        return this.number != this.getInternalNumber(number);
    }

    public NumberValue getNumber() {
        if (this.numberValue == null) {
            this.numberValue = new DefaultNumberValue(this.getBigDecimal());
        }
        return this.numberValue;
    }

    public String toString() {
        return this.currency.toString() + ' ' + this.getBigDecimal();
    }

    private void checkNumber(Number number) {
        Objects.requireNonNull(number, "Number is required.");
    }

    public FastMoney with(MonetaryOperator operator) {
        Objects.requireNonNull(operator);
        try {
            return (FastMoney)FastMoney.class.cast(operator.apply((MonetaryAmount)this));
        }
        catch (Exception e) {
            throw new MonetaryException("Operator failed: " + operator, (Throwable)e);
        }
    }

    public <R> R query(MonetaryQuery<R> query) {
        Objects.requireNonNull(query);
        try {
            return (R)query.queryFrom((MonetaryAmount)this);
        }
        catch (Exception e) {
            throw new MonetaryException("Query failed: " + query, (Throwable)e);
        }
    }

    public static FastMoney from(MonetaryAmount amount) {
        if (FastMoney.class == amount.getClass()) {
            return (FastMoney)amount;
        }
        if (Money.class == amount.getClass()) {
            return new FastMoney(amount.getCurrency(), amount.getNumber());
        }
        return new FastMoney(amount.getCurrency(), amount.getNumber());
    }

    private BigDecimal getBigDecimal() {
        return BigDecimal.valueOf(this.number).movePointLeft(5);
    }

    @Override
    public MonetaryContext getMonetaryContext() {
        return MONETARY_CONTEXT;
    }

    public FastMoney multiply(double amount) {
        if (amount == 1.0) {
            return this;
        }
        if (amount == 0.0) {
            return new FastMoney(this.currency, 0L);
        }
        return new FastMoney(this.currency, Math.round((double)this.number * amount));
    }

    public FastMoney divide(long amount) {
        if (amount == 1L) {
            return this;
        }
        return new FastMoney(this.currency, this.number / amount);
    }

    public FastMoney divide(double number) {
        return new FastMoney(this.getCurrency(), Math.round((double)this.number / number));
    }

    public FastMoney remainder(long number) {
        return this.remainder(BigDecimal.valueOf(number));
    }

    public FastMoney remainder(double amount) {
        return this.remainder(new BigDecimal(String.valueOf(amount)));
    }

    public FastMoney[] divideAndRemainder(long amount) {
        return this.divideAndRemainder(BigDecimal.valueOf(amount));
    }

    public FastMoney[] divideAndRemainder(double amount) {
        return this.divideAndRemainder(new BigDecimal(String.valueOf(amount)));
    }

    public FastMoney stripTrailingZeros() {
        return this;
    }

    public FastMoney multiply(long multiplicand) {
        if (multiplicand == 1L) {
            return this;
        }
        if (multiplicand == 0L) {
            return new FastMoney(this.currency, 0L);
        }
        return new FastMoney(this.currency, multiplicand * this.number);
    }

    public FastMoney divideToIntegralValue(long divisor) {
        if (divisor == 1L) {
            return this;
        }
        return this.divideToIntegralValue(FastMoney.getBigDecimal(divisor));
    }

    public FastMoney divideToIntegralValue(double divisor) {
        if (divisor == 1.0) {
            return this;
        }
        return this.divideToIntegralValue(FastMoney.getBigDecimal(divisor));
    }

    @Override
    protected MonetaryContext getDefaultMonetaryContext() {
        return MONETARY_CONTEXT;
    }

    public MonetaryAmountFactory<FastMoney> getFactory() {
        return new FastMoneyAmountFactory().setAmount(this);
    }
}

