/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryContext;
import javax.money.MonetaryCurrencies;
import javax.money.MonetaryException;
import javax.money.MonetaryOperator;
import javax.money.MonetaryQuery;
import javax.money.NumberValue;
import org.javamoney.moneta.internal.MoneyAmountFactory;
import org.javamoney.moneta.spi.AbstractMoney;
import org.javamoney.moneta.spi.DefaultNumberValue;
import org.javamoney.moneta.spi.MonetaryConfig;

public final class Money
extends AbstractMoney
implements Comparable<MonetaryAmount>,
Serializable {
    private static final long serialVersionUID = -7565813772046251748L;
    public static final MonetaryContext DEFAULT_MONETARY_CONTEXT = Money.initDefaultMathContext();
    private BigDecimal number;

    private Money() {
    }

    private Money(CurrencyUnit currency, BigDecimal number) {
        this(currency, number, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MonetaryContext initDefaultMathContext() {
        InputStream is = null;
        try {
            Map<String, String> config = MonetaryConfig.getConfig();
            String value = config.get("org.javamoney.moneta.Money.defaults.precision");
            if (value != null) {
                int prec = Integer.parseInt(value);
                value = config.get("org.javamoney.moneta.Money.defaults.roundingMode");
                RoundingMode rm = value != null ? RoundingMode.valueOf(value.toUpperCase(Locale.ENGLISH)) : RoundingMode.HALF_UP;
                MonetaryContext mc = ((MonetaryContext.Builder)new MonetaryContext.Builder().setPrecision(prec).set((Object)rm)).setAmountType(Money.class).create();
                Logger.getLogger(Money.class.getName()).info("Using custom MathContext: precision=" + prec + ", roundingMode=" + (Object)((Object)rm));
                MonetaryContext monetaryContext = mc;
                return monetaryContext;
            }
            MonetaryContext.Builder builder = new MonetaryContext.Builder(Money.class);
            value = config.get("org.javamoney.moneta.Money.defaults.mathContext");
            if (value != null) {
                switch (value.toUpperCase(Locale.ENGLISH)) {
                    case "DECIMAL32": {
                        Logger.getLogger(Money.class.getName()).info("Using MathContext.DECIMAL32");
                        builder.set((Object)MathContext.DECIMAL32);
                        break;
                    }
                    case "DECIMAL64": {
                        Logger.getLogger(Money.class.getName()).info("Using MathContext.DECIMAL64");
                        builder.set((Object)MathContext.DECIMAL64);
                        break;
                    }
                    case "DECIMAL128": {
                        Logger.getLogger(Money.class.getName()).info("Using MathContext.DECIMAL128");
                        builder.set((Object)MathContext.DECIMAL128);
                        break;
                    }
                    case "UNLIMITED": {
                        Logger.getLogger(Money.class.getName()).info("Using MathContext.UNLIMITED");
                        builder.set((Object)MathContext.UNLIMITED);
                    }
                }
            } else {
                Logger.getLogger(Money.class.getName()).info("Using default MathContext.DECIMAL64");
                builder.set((Object)MathContext.DECIMAL64);
            }
            String string = builder.create();
            return string;
        }
        catch (Exception e) {
            Logger.getLogger(Money.class.getName()).log(Level.SEVERE, "Error evaluating default NumericContext, using default (NumericContext.NUM64).", e);
            MonetaryContext monetaryContext = ((MonetaryContext.Builder)new MonetaryContext.Builder(Money.class).set((Object)MathContext.DECIMAL64)).create();
            return monetaryContext;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    Logger.getLogger(Money.class.getName()).log(Level.WARNING, "Error closing InputStream after evaluating default NumericContext.", e);
                }
            }
        }
    }

    private Money(CurrencyUnit currency, BigDecimal number, MonetaryContext monetaryContext) {
        super(currency, monetaryContext);
        Objects.requireNonNull(number, "Number is required.");
        this.number = monetaryContext != null ? Money.getBigDecimal(number, monetaryContext) : Money.getBigDecimal(number, DEFAULT_MONETARY_CONTEXT);
    }

    public NumberValue getNumber() {
        return new DefaultNumberValue(this.number);
    }

    public BigDecimal getNumberStripped() {
        if (this.isZero()) {
            return BigDecimal.ZERO;
        }
        return this.number.stripTrailingZeros();
    }

    @Override
    public int compareTo(MonetaryAmount o) {
        Objects.requireNonNull(o);
        int compare = this.getCurrency().getCurrencyCode().compareTo(o.getCurrency().getCurrencyCode());
        if (compare == 0) {
            compare = this.number.compareTo(Money.from((MonetaryAmount)o).number);
        }
        return compare;
    }

    public Money abs() {
        if (this.isPositiveOrZero()) {
            return this;
        }
        return this.negate();
    }

    public Money divide(long divisor) {
        if (divisor == 1L) {
            return this;
        }
        return this.divide(BigDecimal.valueOf(divisor));
    }

    public Money divide(double divisor) {
        if (divisor == 1.0) {
            return this;
        }
        return this.divide(new BigDecimal(String.valueOf(divisor)));
    }

    public Money[] divideAndRemainder(long divisor) {
        return this.divideAndRemainder(BigDecimal.valueOf(divisor));
    }

    public Money[] divideAndRemainder(double divisor) {
        return this.divideAndRemainder(new BigDecimal(String.valueOf(divisor)));
    }

    public Money multiply(long multiplicand) {
        return this.multiply(BigDecimal.valueOf(multiplicand));
    }

    public Money multiply(double multiplicand) {
        return this.multiply(new BigDecimal(String.valueOf(multiplicand)));
    }

    public Money remainder(long divisor) {
        return this.remainder(BigDecimal.valueOf(divisor));
    }

    public Money remainder(double divisor) {
        return this.remainder(new BigDecimal(String.valueOf(divisor)));
    }

    public boolean isZero() {
        return this.signum() == 0;
    }

    public boolean isPositive() {
        return this.signum() == 1;
    }

    public boolean isPositiveOrZero() {
        return this.signum() >= 0;
    }

    public boolean isNegative() {
        return this.signum() == -1;
    }

    public boolean isNegativeOrZero() {
        return this.signum() <= 0;
    }

    public <R> R query(MonetaryQuery<R> query) {
        Objects.requireNonNull(query);
        try {
            return (R)query.queryFrom((MonetaryAmount)this);
        }
        catch (Exception e) {
            throw new MonetaryException("Query failed: " + query, (Throwable)e);
        }
    }

    public Money with(MonetaryOperator operator) {
        Objects.requireNonNull(operator);
        try {
            return (Money)Money.class.cast(operator.apply((MonetaryAmount)this));
        }
        catch (Exception e) {
            throw new MonetaryException("Operator failed: " + operator, (Throwable)e);
        }
    }

    public Money add(MonetaryAmount amount) {
        this.checkAmountParameter(amount);
        if (amount.isZero()) {
            return this;
        }
        return new Money(this.getCurrency(), this.number.add((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)));
    }

    public Money divide(Number divisor) {
        BigDecimal divisorBD = Money.getBigDecimal(divisor);
        if (divisorBD.equals(BigDecimal.ONE)) {
            return this;
        }
        BigDecimal dec = this.number.divide(divisorBD, Money.getMathContext(this.getMonetaryContext(), RoundingMode.HALF_EVEN));
        return new Money(this.getCurrency(), dec);
    }

    public Money[] divideAndRemainder(Number divisor) {
        BigDecimal divisorBD = Money.getBigDecimal(divisor);
        if (divisorBD.equals(BigDecimal.ONE)) {
            return new Money[]{this, new Money(this.getCurrency(), BigDecimal.ZERO)};
        }
        BigDecimal[] dec = this.number.divideAndRemainder(divisorBD);
        return new Money[]{new Money(this.getCurrency(), dec[0]), new Money(this.getCurrency(), dec[1])};
    }

    public Money divideToIntegralValue(long divisor) {
        return this.divideToIntegralValue(Money.getBigDecimal(divisor));
    }

    public Money divideToIntegralValue(double divisor) {
        return this.divideToIntegralValue(Money.getBigDecimal(divisor));
    }

    public Money divideToIntegralValue(Number divisor) {
        BigDecimal divisorBD = Money.getBigDecimal(divisor);
        BigDecimal dec = this.number.divideToIntegralValue(divisorBD);
        return new Money(this.getCurrency(), dec);
    }

    public Money multiply(Number multiplicand) {
        BigDecimal multiplicandBD = Money.getBigDecimal(multiplicand);
        if (multiplicandBD.equals(BigDecimal.ONE)) {
            return this;
        }
        BigDecimal dec = this.number.multiply(multiplicandBD);
        return new Money(this.getCurrency(), dec);
    }

    public Money negate() {
        return new Money(this.getCurrency(), this.number.negate());
    }

    public Money plus() {
        return new Money(this.getCurrency(), this.number.plus());
    }

    public Money subtract(MonetaryAmount subtrahend) {
        this.checkAmountParameter(subtrahend);
        if (subtrahend.isZero()) {
            return this;
        }
        return new Money(this.getCurrency(), this.number.subtract((BigDecimal)subtrahend.getNumber().numberValue(BigDecimal.class)));
    }

    public Money stripTrailingZeros() {
        if (this.isZero()) {
            return new Money(this.getCurrency(), BigDecimal.ZERO);
        }
        return new Money(this.getCurrency(), this.number.stripTrailingZeros());
    }

    public Money remainder(Number divisor) {
        BigDecimal bd = Money.getBigDecimal(divisor);
        return new Money(this.getCurrency(), this.number.remainder(bd));
    }

    public Money scaleByPowerOfTen(int n) {
        return new Money(this.getCurrency(), this.number.scaleByPowerOfTen(n));
    }

    public int signum() {
        return this.number.signum();
    }

    public boolean isLessThan(MonetaryAmount amount) {
        this.checkAmountParameter(amount);
        return this.number.compareTo(Money.from((MonetaryAmount)amount).number) < 0;
    }

    public boolean isLessThanOrEqualTo(MonetaryAmount amount) {
        this.checkAmountParameter(amount);
        return this.number.compareTo(Money.from((MonetaryAmount)amount).number) <= 0;
    }

    public boolean isGreaterThan(MonetaryAmount amount) {
        this.checkAmountParameter(amount);
        return this.number.compareTo(Money.from((MonetaryAmount)amount).number) > 0;
    }

    public boolean isGreaterThanOrEqualTo(MonetaryAmount amount) {
        this.checkAmountParameter(amount);
        return this.number.compareTo(Money.from((MonetaryAmount)amount).number) >= 0;
    }

    public boolean isEqualTo(MonetaryAmount amount) {
        this.checkAmountParameter(amount);
        return this.equals(Money.from(amount));
    }

    public MonetaryAmountFactory<Money> getFactory() {
        return new MoneyAmountFactory().setAmount(this);
    }

    @Override
    protected MonetaryContext getDefaultMonetaryContext() {
        return DEFAULT_MONETARY_CONTEXT;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.number);
        oos.writeObject(this.currency);
        oos.writeObject(this.monetaryContext);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Money other = (Money)obj;
        if (!this.getCurrency().equals(other.getCurrency())) {
            return false;
        }
        return this.getNumberStripped().equals(other.getNumberStripped());
    }

    public String toString() {
        return this.getCurrency().getCurrencyCode() + ' ' + this.number.toString();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.number = (BigDecimal)ois.readObject();
        this.currency = (CurrencyUnit)ois.readObject();
        this.monetaryContext = (MonetaryContext)ois.readObject();
    }

    private void readObjectNoData() throws ObjectStreamException {
        if (this.number == null) {
            this.number = BigDecimal.ZERO;
        }
        if (this.monetaryContext == null) {
            this.monetaryContext = DEFAULT_MONETARY_CONTEXT;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getCurrency().hashCode();
        return 31 * result + this.getNumberStripped().hashCode();
    }

    public static Money of(CurrencyUnit currency, BigDecimal number) {
        return new Money(currency, number);
    }

    public static Money of(CurrencyUnit currency, BigDecimal number, MonetaryContext monetaryContext) {
        return new Money(currency, number, monetaryContext);
    }

    public static Money of(CurrencyUnit currency, Number number) {
        return new Money(currency, Money.getBigDecimal(number));
    }

    public static Money of(CurrencyUnit currency, Number number, MonetaryContext monetaryContext) {
        return new Money(currency, Money.getBigDecimal(number), monetaryContext);
    }

    public static Money of(String currencyCode, Number number) {
        return new Money(MonetaryCurrencies.getCurrency((String)currencyCode), Money.getBigDecimal(number));
    }

    public static Money of(String currencyCode, BigDecimal number) {
        return new Money(MonetaryCurrencies.getCurrency((String)currencyCode), number);
    }

    public static Money of(String currencyCode, Number number, MonetaryContext monetaryContext) {
        return new Money(MonetaryCurrencies.getCurrency((String)currencyCode), Money.getBigDecimal(number), monetaryContext);
    }

    public static Money of(String currencyCode, BigDecimal number, MonetaryContext monetaryContext) {
        return new Money(MonetaryCurrencies.getCurrency((String)currencyCode), number, monetaryContext);
    }

    public static Money from(MonetaryAmount amt) {
        if (amt.getClass() == Money.class) {
            return (Money)amt;
        }
        return Money.of(amt.getCurrency(), (BigDecimal)amt.getNumber().numberValue(BigDecimal.class), amt.getMonetaryContext());
    }
}

