/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryContext;
import javax.money.MonetaryCurrencies;
import javax.money.MonetaryException;
import javax.money.MonetaryOperator;
import javax.money.MonetaryQuery;
import javax.money.MonetaryRoundings;
import javax.money.NumberValue;
import org.javamoney.moneta.FastMoney;
import org.javamoney.moneta.Money;
import org.javamoney.moneta.internal.RoundedMoneyAmountFactory;
import org.javamoney.moneta.spi.AbstractMoney;
import org.javamoney.moneta.spi.DefaultNumberValue;

public final class RoundedMoney
extends AbstractMoney
implements Comparable<MonetaryAmount>,
Serializable {
    private static final long serialVersionUID = 366517590511294389L;
    public static final MonetaryContext DEFAULT_MONETARY_CONTEXT = MonetaryContext.from((MonetaryContext)Money.DEFAULT_MONETARY_CONTEXT, RoundedMoney.class);
    private BigDecimal number;
    private MonetaryOperator rounding;

    private RoundedMoney() {
    }

    private RoundedMoney(CurrencyUnit currency, Number number, MonetaryContext monetaryContext, MonetaryOperator rounding) {
        super(currency, monetaryContext);
        Objects.requireNonNull(number, "Number is required.");
        this.checkNumber(number);
        this.currency = currency;
        this.rounding = rounding != null ? rounding : MonetaryRoundings.getRounding((CurrencyUnit)currency);
        this.number = RoundedMoney.getBigDecimal(number, monetaryContext);
    }

    public static RoundedMoney of(CurrencyUnit currency, BigDecimal number) {
        return new RoundedMoney(currency, number, DEFAULT_MONETARY_CONTEXT, null);
    }

    public static RoundedMoney of(CurrencyUnit currency, BigDecimal number, MonetaryOperator rounding) {
        return new RoundedMoney(currency, number, DEFAULT_MONETARY_CONTEXT, rounding);
    }

    public static RoundedMoney of(CurrencyUnit currency, BigDecimal number, MonetaryContext monetaryContext) {
        return new RoundedMoney(currency, number, MonetaryContext.from((MonetaryContext)monetaryContext, RoundedMoney.class), null);
    }

    public static RoundedMoney of(CurrencyUnit currency, BigDecimal number, MonetaryContext monetaryContext, MonetaryOperator rounding) {
        return new RoundedMoney(currency, number, MonetaryContext.from((MonetaryContext)monetaryContext, RoundedMoney.class), rounding);
    }

    public static RoundedMoney of(CurrencyUnit currency, Number number) {
        return new RoundedMoney(currency, number, null, null);
    }

    public static RoundedMoney of(CurrencyUnit currency, Number number, MonetaryOperator rounding) {
        return new RoundedMoney(currency, number, null, rounding);
    }

    public static RoundedMoney of(CurrencyUnit currency, Number number, MonetaryContext monetaryContext) {
        return new RoundedMoney(currency, number, MonetaryContext.from((MonetaryContext)monetaryContext, RoundedMoney.class), null);
    }

    public static RoundedMoney of(CurrencyUnit currency, Number number, MonetaryContext monetaryContext, MonetaryOperator rounding) {
        return new RoundedMoney(currency, number, MonetaryContext.from((MonetaryContext)monetaryContext, RoundedMoney.class), rounding);
    }

    public static RoundedMoney of(String currencyCode, Number number) {
        return new RoundedMoney(MonetaryCurrencies.getCurrency((String)currencyCode), number, DEFAULT_MONETARY_CONTEXT, MonetaryRoundings.getRounding((CurrencyUnit)MonetaryCurrencies.getCurrency((String)currencyCode)));
    }

    public static RoundedMoney of(String currencyCode, Number number, MonetaryOperator rounding) {
        return new RoundedMoney(MonetaryCurrencies.getCurrency((String)currencyCode), number, DEFAULT_MONETARY_CONTEXT, rounding);
    }

    public static RoundedMoney of(String currencyCode, Number number, MonetaryContext monetaryContext) {
        return new RoundedMoney(MonetaryCurrencies.getCurrency((String)currencyCode), number, MonetaryContext.from((MonetaryContext)monetaryContext, RoundedMoney.class), MonetaryRoundings.getRounding((MonetaryContext)monetaryContext));
    }

    public static RoundedMoney of(String currencyCode, Number number, MonetaryContext monetaryContext, MonetaryOperator rounding) {
        return new RoundedMoney(MonetaryCurrencies.getCurrency((String)currencyCode), number, MonetaryContext.from((MonetaryContext)monetaryContext, RoundedMoney.class), rounding);
    }

    @Override
    public CurrencyUnit getCurrency() {
        return this.currency;
    }

    @Override
    public MonetaryContext getMonetaryContext() {
        return this.monetaryContext;
    }

    public RoundedMoney abs() {
        if (this.isPositiveOrZero()) {
            return this;
        }
        return this.negate();
    }

    public RoundedMoney add(MonetaryAmount amount) {
        this.checkAmountParameter(amount);
        return new RoundedMoney(this.currency, this.number.add((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)), this.monetaryContext, this.rounding).with(this.rounding);
    }

    public RoundedMoney divide(Number divisor) {
        BigDecimal dec = this.number.divide(RoundedMoney.getBigDecimal(divisor), (RoundingMode)((Object)this.monetaryContext.getAttribute(RoundingMode.class, (Object)RoundingMode.HALF_EVEN)));
        return new RoundedMoney(this.currency, dec, this.monetaryContext, this.rounding).with(this.rounding);
    }

    public RoundedMoney[] divideAndRemainder(Number divisor) {
        BigDecimal[] dec = this.number.divideAndRemainder(RoundedMoney.getBigDecimal(divisor), (MathContext)this.monetaryContext.getAttribute(MathContext.class, (Object)MathContext.DECIMAL64));
        return new RoundedMoney[]{new RoundedMoney(this.currency, dec[0], this.monetaryContext, this.rounding), new RoundedMoney(this.currency, dec[1], this.monetaryContext, this.rounding).with(this.rounding)};
    }

    public RoundedMoney divideToIntegralValue(Number divisor) {
        BigDecimal dec = this.number.divideToIntegralValue(RoundedMoney.getBigDecimal(divisor), (MathContext)this.monetaryContext.getAttribute(MathContext.class, (Object)MathContext.DECIMAL64));
        return new RoundedMoney(this.currency, dec, this.monetaryContext, this.rounding);
    }

    public RoundedMoney multiply(Number multiplicand) {
        BigDecimal dec = this.number.multiply(RoundedMoney.getBigDecimal(multiplicand), (MathContext)this.monetaryContext.getAttribute(MathContext.class, (Object)MathContext.DECIMAL64));
        return new RoundedMoney(this.currency, dec, this.monetaryContext, this.rounding).with(this.rounding);
    }

    public RoundedMoney negate() {
        return new RoundedMoney(this.currency, this.number.negate((MathContext)this.monetaryContext.getAttribute(MathContext.class, (Object)MathContext.DECIMAL64)), this.monetaryContext, this.rounding);
    }

    public RoundedMoney plus() {
        return new RoundedMoney(this.currency, this.number.plus((MathContext)this.monetaryContext.getAttribute(MathContext.class, (Object)MathContext.DECIMAL64)), this.monetaryContext, this.rounding);
    }

    public RoundedMoney subtract(MonetaryAmount subtrahend) {
        this.checkAmountParameter(subtrahend);
        if (subtrahend.isZero()) {
            return this;
        }
        return new RoundedMoney(this.currency, this.number.subtract((BigDecimal)subtrahend.getNumber().numberValue(BigDecimal.class), (MathContext)this.monetaryContext.getAttribute(MathContext.class, (Object)MathContext.DECIMAL64)), this.monetaryContext, this.rounding);
    }

    public RoundedMoney pow(int n) {
        return new RoundedMoney(this.currency, this.number.pow(n, (MathContext)this.monetaryContext.getAttribute(MathContext.class, (Object)MathContext.DECIMAL64)), this.monetaryContext, this.rounding).with(this.rounding);
    }

    public RoundedMoney ulp() {
        return new RoundedMoney(this.currency, this.number.ulp(), DEFAULT_MONETARY_CONTEXT, this.rounding);
    }

    public RoundedMoney remainder(Number divisor) {
        return new RoundedMoney(this.currency, this.number.remainder(RoundedMoney.getBigDecimal(divisor), (MathContext)this.monetaryContext.getAttribute(MathContext.class, (Object)MathContext.DECIMAL64)), this.monetaryContext, this.rounding);
    }

    public RoundedMoney scaleByPowerOfTen(int n) {
        return new RoundedMoney(this.currency, this.number.scaleByPowerOfTen(n), this.monetaryContext, this.rounding);
    }

    public boolean isZero() {
        return this.number.signum() == 0;
    }

    public boolean isPositive() {
        return this.signum() == 1;
    }

    public boolean isPositiveOrZero() {
        return this.signum() >= 0;
    }

    public boolean isNegative() {
        return this.signum() == -1;
    }

    public boolean isNegativeOrZero() {
        return this.signum() <= 0;
    }

    public RoundedMoney with(Number amount) {
        this.checkNumber(amount);
        return new RoundedMoney(this.currency, RoundedMoney.getBigDecimal(amount), this.monetaryContext, this.rounding);
    }

    public RoundedMoney with(CurrencyUnit currency) {
        Objects.requireNonNull(currency, "currency required");
        return new RoundedMoney(currency, this.asType(BigDecimal.class), this.monetaryContext, this.rounding);
    }

    public RoundedMoney with(CurrencyUnit currency, Number amount) {
        this.checkNumber(amount);
        return new RoundedMoney(currency, RoundedMoney.getBigDecimal(amount), this.monetaryContext, this.rounding);
    }

    public int getScale() {
        return this.number.scale();
    }

    public int getPrecision() {
        return this.number.precision();
    }

    public int signum() {
        return this.number.signum();
    }

    public boolean isLessThan(MonetaryAmount amount) {
        this.checkAmountParameter(amount);
        return this.number.compareTo((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)) < 0;
    }

    public boolean isLessThanOrEqualTo(MonetaryAmount amount) {
        this.checkAmountParameter(amount);
        return this.number.compareTo((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)) <= 0;
    }

    public boolean isGreaterThan(MonetaryAmount amount) {
        this.checkAmountParameter(amount);
        return this.number.compareTo((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)) > 0;
    }

    public boolean isGreaterThanOrEqualTo(MonetaryAmount amount) {
        this.checkAmountParameter(amount);
        return this.number.compareTo((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)) >= 0;
    }

    public boolean isEqualTo(MonetaryAmount amount) {
        this.checkAmountParameter(amount);
        return this.number.compareTo((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)) == 0;
    }

    public boolean isNotEqualTo(MonetaryAmount amount) {
        this.checkAmountParameter(amount);
        return this.number.compareTo((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)) != 0;
    }

    public RoundedMoney with(MonetaryOperator operator) {
        Objects.requireNonNull(operator);
        try {
            return RoundedMoney.from(operator.apply((MonetaryAmount)this));
        }
        catch (Exception e) {
            throw new MonetaryException("Query failed: " + operator, (Throwable)e);
        }
    }

    public static RoundedMoney from(MonetaryAmount amt) {
        if (amt.getClass() == RoundedMoney.class) {
            return (RoundedMoney)amt;
        }
        if (amt.getClass() == FastMoney.class) {
            return RoundedMoney.of(amt.getCurrency(), (BigDecimal)((FastMoney)amt).getNumber().numberValue(BigDecimal.class), DEFAULT_MONETARY_CONTEXT);
        }
        if (amt.getClass() == Money.class) {
            return RoundedMoney.of(amt.getCurrency(), (BigDecimal)amt.getNumber().numberValue(BigDecimal.class), DEFAULT_MONETARY_CONTEXT);
        }
        return RoundedMoney.of(amt.getCurrency(), (BigDecimal)amt.getNumber().numberValue(BigDecimal.class), DEFAULT_MONETARY_CONTEXT);
    }

    public <T> T query(MonetaryQuery<T> query) {
        Objects.requireNonNull(query);
        try {
            return (T)query.queryFrom((MonetaryAmount)this);
        }
        catch (Exception e) {
            throw new MonetaryException("Query failed: " + query, (Throwable)e);
        }
    }

    public <T> T asType(Class<T> type) {
        if (BigDecimal.class.equals(type)) {
            return (T)this.number;
        }
        if (Number.class.equals(type)) {
            BigDecimal asType = this.number;
            return (T)asType;
        }
        if (Double.class.equals(type)) {
            return (T)Double.valueOf(this.number.doubleValue());
        }
        if (Float.class.equals(type)) {
            return (T)Float.valueOf(this.number.floatValue());
        }
        if (Long.class.equals(type)) {
            return (T)Long.valueOf(this.number.longValue());
        }
        if (Integer.class.equals(type)) {
            return (T)Integer.valueOf(this.number.intValue());
        }
        if (Short.class.equals(type)) {
            return (T)Short.valueOf(this.number.shortValue());
        }
        if (Byte.class.equals(type)) {
            return (T)Byte.valueOf(this.number.byteValue());
        }
        if (BigInteger.class.equals(type)) {
            return (T)this.number.toBigInteger();
        }
        throw new IllegalArgumentException("Unsupported representation type: " + type);
    }

    public <T> T asType(Class<T> type, MonetaryOperator adjuster) {
        RoundedMoney amount = (RoundedMoney)adjuster.apply((MonetaryAmount)this);
        return amount.asType(type);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.number);
        oos.writeObject(this.monetaryContext);
        oos.writeObject(this.currency);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.number = (BigDecimal)ois.readObject();
        this.monetaryContext = (MonetaryContext)ois.readObject();
        this.currency = (CurrencyUnit)ois.readObject();
    }

    private void readObjectNoData() throws ObjectStreamException {
        if (this.number == null) {
            this.number = BigDecimal.ZERO;
        }
        if (this.monetaryContext == null) {
            this.monetaryContext = DEFAULT_MONETARY_CONTEXT;
        }
        if (this.currency == null) {
            this.currency = MonetaryCurrencies.getCurrency((String)"XXX");
        }
    }

    public String toString() {
        return this.currency.getCurrencyCode() + ' ' + this.number;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.currency == null ? 0 : this.currency.hashCode());
        return 31 * result + this.asNumberStripped().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RoundedMoney other = (RoundedMoney)obj;
        if (this.currency == null ? other.currency != null : !this.currency.equals(other.currency)) {
            return false;
        }
        return this.asNumberStripped().equals(other.asNumberStripped());
    }

    @Override
    public int compareTo(MonetaryAmount o) {
        Objects.requireNonNull(o);
        int compare = -1;
        compare = this.currency.equals(o.getCurrency()) ? this.asNumberStripped().compareTo(RoundedMoney.from(o).asNumberStripped()) : this.currency.getCurrencyCode().compareTo(o.getCurrency().getCurrencyCode());
        return compare;
    }

    public NumberValue getNumber() {
        return new DefaultNumberValue(this.number);
    }

    public BigDecimal asNumberStripped() {
        if (this.isZero()) {
            return BigDecimal.ZERO;
        }
        return this.number.stripTrailingZeros();
    }

    private void checkNumber(Number number) {
        Objects.requireNonNull(number, "Number is required.");
    }

    public RoundedMoney multiply(long amount) {
        return this.multiply(RoundedMoney.getBigDecimal(amount));
    }

    public RoundedMoney multiply(double amount) {
        return this.multiply(RoundedMoney.getBigDecimal(amount));
    }

    public RoundedMoney divide(long amount) {
        return this.divide(RoundedMoney.getBigDecimal(amount));
    }

    public RoundedMoney divide(double amount) {
        return this.divide(RoundedMoney.getBigDecimal(amount));
    }

    public RoundedMoney remainder(long amount) {
        return this.remainder(RoundedMoney.getBigDecimal(amount));
    }

    public RoundedMoney remainder(double amount) {
        return this.remainder(RoundedMoney.getBigDecimal(amount));
    }

    public RoundedMoney[] divideAndRemainder(long amount) {
        return this.divideAndRemainder(RoundedMoney.getBigDecimal(amount));
    }

    public RoundedMoney[] divideAndRemainder(double amount) {
        return this.divideAndRemainder(RoundedMoney.getBigDecimal(amount));
    }

    public RoundedMoney stripTrailingZeros() {
        if (this.isZero()) {
            return RoundedMoney.of(this.getCurrency(), BigDecimal.ZERO);
        }
        return RoundedMoney.of(this.getCurrency(), this.number.stripTrailingZeros());
    }

    public RoundedMoney divideToIntegralValue(long divisor) {
        return this.divideToIntegralValue(RoundedMoney.getBigDecimal(divisor));
    }

    public RoundedMoney divideToIntegralValue(double divisor) {
        return this.divideToIntegralValue(RoundedMoney.getBigDecimal(divisor));
    }

    @Override
    protected MonetaryContext getDefaultMonetaryContext() {
        return DEFAULT_MONETARY_CONTEXT;
    }

    public MonetaryAmountFactory<RoundedMoney> getFactory() {
        return new RoundedMoneyAmountFactory().setAmount(this);
    }
}

