/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.convert.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.money.CurrencyUnit;
import javax.money.convert.ConversionContext;
import javax.money.convert.CurrencyConversion;
import javax.money.convert.ExchangeRateProvider;
import javax.money.convert.ProviderContext;
import javax.money.spi.Bootstrap;
import javax.money.spi.MonetaryConversionsSpi;
import org.javamoney.moneta.spi.CompoundRateProvider;

public class DefaultMonetaryConversionsSpi
implements MonetaryConversionsSpi {
    private Map<String, ExchangeRateProvider> conversionProviders = new ConcurrentHashMap<String, ExchangeRateProvider>();

    public DefaultMonetaryConversionsSpi() {
        this.reload();
    }

    public void reload() {
        ConcurrentHashMap<String, ExchangeRateProvider> newProviders = new ConcurrentHashMap<String, ExchangeRateProvider>();
        for (ExchangeRateProvider prov : Bootstrap.getServices(ExchangeRateProvider.class)) {
            newProviders.put(prov.getProviderContext().getProviderName(), prov);
        }
        this.conversionProviders = newProviders;
    }

    public ExchangeRateProvider getExchangeRateProvider(String ... providers) {
        ArrayList<ExchangeRateProvider> provInstances = new ArrayList<ExchangeRateProvider>();
        for (String provName : providers) {
            ExchangeRateProvider prov = this.conversionProviders.get(provName);
            if (prov == null) {
                throw new IllegalArgumentException("Unsupported conversion/rate provider: " + provName);
            }
            provInstances.add(prov);
        }
        return new CompoundRateProvider(provInstances);
    }

    public Set<String> getProviderNames() {
        return this.conversionProviders.keySet();
    }

    public boolean isProviderAvailable(String provider) {
        return this.conversionProviders.containsKey(provider);
    }

    public CurrencyConversion getConversion(CurrencyUnit termCurrency, ConversionContext conversionContext, String ... providers) {
        return this.getExchangeRateProvider(providers).getCurrencyConversion(termCurrency);
    }

    public List<String> getDefaultProviderChain() {
        ArrayList<String> stringList = new ArrayList<String>();
        stringList.add("test");
        return stringList;
    }

    public ProviderContext getProviderContext(String provider) {
        ExchangeRateProvider prov = this.getExchangeRateProvider(provider);
        return prov.getProviderContext();
    }
}

