/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.convert.internal;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.money.CurrencyUnit;
import javax.money.MonetaryCurrencies;
import javax.money.NumberValue;
import javax.money.convert.ConversionContext;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ProviderContext;
import javax.money.convert.RateType;
import javax.money.spi.Bootstrap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.javamoney.moneta.spi.AbstractRateProvider;
import org.javamoney.moneta.spi.DefaultNumberValue;
import org.javamoney.moneta.spi.LoaderService;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ECBCurrentRateProvider
extends AbstractRateProvider
implements LoaderService.LoaderListener {
    private static final String BASE_CURRENCY_CODE = "EUR";
    public static final CurrencyUnit BASE_CURRENCY = MonetaryCurrencies.getCurrency((String)"EUR");
    private static final String DATA_ID = ECBCurrentRateProvider.class.getSimpleName();
    private Map<String, ExchangeRate> currentRates = new ConcurrentHashMap<String, ExchangeRate>();
    private SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
    private static final ProviderContext CONTEXT = ((ProviderContext.Builder)((ProviderContext.Builder)new ProviderContext.Builder("ECB").setRateTypes(new RateType[]{RateType.DEFERRED}).set((Object)"European Central Bank", (Object)"providerDescription")).set((Object)1, (Object)"days")).create();

    public ECBCurrentRateProvider() throws MalformedURLException {
        super(CONTEXT);
        this.saxParserFactory.setNamespaceAware(false);
        this.saxParserFactory.setValidating(false);
        LoaderService loader = (LoaderService)Bootstrap.getService(LoaderService.class);
        loader.addLoaderListener(this, DATA_ID);
        try {
            loader.loadData(DATA_ID);
        }
        catch (IOException e) {
            this.LOGGER.log(Level.SEVERE, "Error loading ECB data.", e);
        }
    }

    @Override
    public void newDataLoaded(String data, InputStream is) {
        try {
            SAXParser parser = this.saxParserFactory.newSAXParser();
            parser.parse(is, (DefaultHandler)new RateReadingHandler());
            this.LOGGER.info("Loaded current " + DATA_ID + " exchange rates.");
        }
        catch (Exception e) {
            this.LOGGER.log(Level.SEVERE, "Error reading resource for ECB currencies: ", e);
        }
    }

    @Override
    protected ExchangeRate getExchangeRateInternal(CurrencyUnit base, CurrencyUnit term, ConversionContext context) {
        if (context.getTimestamp() != null) {
            return null;
        }
        ExchangeRate.Builder builder = new ExchangeRate.Builder(ConversionContext.of((String)CONTEXT.getProviderName(), (RateType)RateType.DEFERRED, (Long)context.getTimestamp()));
        builder.setBase(base);
        builder.setTerm(term);
        ExchangeRate sourceRate = null;
        ExchangeRate target = null;
        if (this.currentRates.isEmpty()) {
            return null;
        }
        sourceRate = this.currentRates.get(base.getCurrencyCode());
        target = this.currentRates.get(term.getCurrencyCode());
        if (BASE_CURRENCY_CODE.equals(base.getCurrencyCode()) && BASE_CURRENCY_CODE.equals(term.getCurrencyCode())) {
            builder.setFactor(DefaultNumberValue.ONE);
            return builder.create();
        }
        if (BASE_CURRENCY_CODE.equals(term.getCurrencyCode())) {
            if (sourceRate == null) {
                return null;
            }
            return this.getReversed(sourceRate);
        }
        if (BASE_CURRENCY_CODE.equals(base.getCurrencyCode())) {
            return target;
        }
        ExchangeRate rate1 = this.getExchangeRateInternal(base, MonetaryCurrencies.getCurrency((String)BASE_CURRENCY_CODE), context);
        ExchangeRate rate2 = this.getExchangeRateInternal(MonetaryCurrencies.getCurrency((String)BASE_CURRENCY_CODE), term, context);
        if (rate1 != null && rate2 != null) {
            builder.setFactor(ECBCurrentRateProvider.multiply(rate1.getFactor(), rate2.getFactor()));
            builder.setRateChain(new ExchangeRate[]{rate1, rate2});
            return builder.create();
        }
        return null;
    }

    void addRate(CurrencyUnit term, Long timestamp, Number factor) {
        ExchangeRate.Builder builder = new ExchangeRate.Builder(ConversionContext.of((String)CONTEXT.getProviderName(), (RateType)RateType.DEFERRED, (Long)timestamp));
        builder.setBase(BASE_CURRENCY);
        builder.setTerm(term);
        builder.setFactor((NumberValue)new DefaultNumberValue(factor));
        this.currentRates.put(term.getCurrencyCode(), builder.create());
    }

    private class RateReadingHandler
    extends DefaultHandler {
        private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        private Long timestamp;

        public RateReadingHandler() {
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            try {
                if ("Cube".equals(qName)) {
                    if (attributes.getValue("time") != null) {
                        Date date = this.dateFormat.parse(attributes.getValue("time"));
                        this.timestamp = date.getTime();
                    } else if (attributes.getValue("currency") != null) {
                        CurrencyUnit tgtCurrency = MonetaryCurrencies.getCurrency((String)attributes.getValue("currency"));
                        ECBCurrentRateProvider.this.addRate(tgtCurrency, this.timestamp, BigDecimal.valueOf(Double.parseDouble(attributes.getValue("rate"))));
                    }
                }
                super.startElement(uri, localName, qName, attributes);
            }
            catch (ParseException e) {
                throw new SAXException("Failed to read.", e);
            }
        }
    }
}

