/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.convert.internal;

import java.io.InputStream;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.money.CurrencyUnit;
import javax.money.MonetaryCurrencies;
import javax.money.NumberValue;
import javax.money.convert.ConversionContext;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ProviderContext;
import javax.money.convert.RateType;
import javax.money.spi.Bootstrap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.javamoney.moneta.spi.AbstractRateProvider;
import org.javamoney.moneta.spi.DefaultNumberValue;
import org.javamoney.moneta.spi.LoaderService;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ECBHistoric90RateProvider
extends AbstractRateProvider
implements LoaderService.LoaderListener {
    private static final String DATA_ID = ECBHistoric90RateProvider.class.getSimpleName();
    private static final String BASE_CURRENCY_CODE = "EUR";
    public static final CurrencyUnit BASE_CURRENCY = MonetaryCurrencies.getCurrency((String)"EUR");
    private Map<Long, Map<String, ExchangeRate>> rates = new ConcurrentHashMap<Long, Map<String, ExchangeRate>>();
    private SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
    private static final ProviderContext CONTEXT = ((ProviderContext.Builder)((ProviderContext.Builder)new ProviderContext.Builder("ECB-HIST90").setRateTypes(new RateType[]{RateType.HISTORIC, RateType.DEFERRED}).set((Object)"European Central Bank (last 90 days)", (Object)"providerDescription")).set((Object)90, (Object)"days")).create();

    public ECBHistoric90RateProvider() throws MalformedURLException {
        super(CONTEXT);
        this.saxParserFactory.setNamespaceAware(false);
        this.saxParserFactory.setValidating(false);
        LoaderService loader = (LoaderService)Bootstrap.getService(LoaderService.class);
        loader.addLoaderListener(this, DATA_ID);
        loader.loadDataAsync(DATA_ID);
    }

    @Override
    public void newDataLoaded(String data, InputStream is) {
        int oldSize = this.rates.size();
        try {
            SAXParser parser = this.saxParserFactory.newSAXParser();
            parser.parse(is, (DefaultHandler)new RateReadingHandler());
        }
        catch (Exception e) {
            this.LOGGER.log(Level.FINEST, "Error during data load.", e);
        }
        int newSize = this.rates.size();
        this.LOGGER.info("Loaded " + DATA_ID + " exchange rates for days:" + (newSize - oldSize));
    }

    @Override
    protected ExchangeRate getExchangeRateInternal(CurrencyUnit base, CurrencyUnit term, ConversionContext context) {
        ExchangeRate sourceRate = null;
        ExchangeRate target = null;
        if (context.getTimestamp() == null) {
            return null;
        }
        ExchangeRate.Builder builder = new ExchangeRate.Builder(ConversionContext.of((String)CONTEXT.getProviderName(), (RateType)RateType.HISTORIC, (Long)context.getTimestamp()));
        if (this.rates.isEmpty()) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.setTimeInMillis(context.getTimestamp());
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Long targetTS = cal.getTimeInMillis();
        builder.setBase(base);
        builder.setTerm(term);
        Map<String, ExchangeRate> targets = this.rates.get(targetTS);
        if (targets == null) {
            return null;
        }
        sourceRate = targets.get(base.getCurrencyCode());
        target = targets.get(term.getCurrencyCode());
        if (BASE_CURRENCY_CODE.equals(base.getCurrencyCode()) && BASE_CURRENCY_CODE.equals(term.getCurrencyCode())) {
            builder.setFactor(DefaultNumberValue.ONE);
            return builder.create();
        }
        if (BASE_CURRENCY_CODE.equals(term.getCurrencyCode())) {
            if (sourceRate == null) {
                return null;
            }
            return this.getReversed(sourceRate);
        }
        if (BASE_CURRENCY_CODE.equals(base.getCurrencyCode())) {
            return target;
        }
        ExchangeRate rate1 = this.getExchangeRateInternal(base, MonetaryCurrencies.getCurrency((String)BASE_CURRENCY_CODE), context);
        ExchangeRate rate2 = this.getExchangeRateInternal(MonetaryCurrencies.getCurrency((String)BASE_CURRENCY_CODE), term, context);
        if (rate1 != null || rate2 != null) {
            builder.setFactor(ECBHistoric90RateProvider.multiply(rate1.getFactor(), rate2.getFactor()));
            builder.setRateChain(new ExchangeRate[]{rate1, rate2});
            return builder.create();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRate(CurrencyUnit term, Long timestamp, Number rate) {
        ExchangeRate.Builder builder = null;
        RateType rateType = RateType.HISTORIC;
        if (timestamp != null) {
            if (timestamp > System.currentTimeMillis()) {
                rateType = RateType.DEFERRED;
            }
            builder = new ExchangeRate.Builder(ConversionContext.of((String)CONTEXT.getProviderName(), (RateType)rateType, (Long)timestamp));
        } else {
            builder = new ExchangeRate.Builder(ConversionContext.of((String)CONTEXT.getProviderName(), (RateType)rateType));
        }
        builder.setBase(BASE_CURRENCY);
        builder.setTerm(term);
        builder.setFactor((NumberValue)new DefaultNumberValue(rate));
        ExchangeRate exchangeRate = builder.create();
        Map<String, ExchangeRate> rateMap = this.rates.get(timestamp);
        if (rateMap == null) {
            Map<Long, Map<String, ExchangeRate>> map = this.rates;
            synchronized (map) {
                rateMap = this.rates.get(timestamp);
                if (rateMap == null) {
                    rateMap = new ConcurrentHashMap<String, ExchangeRate>();
                    this.rates.put(timestamp, rateMap);
                }
            }
        }
        rateMap.put(term.getCurrencyCode(), exchangeRate);
    }

    private class RateReadingHandler
    extends DefaultHandler {
        private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        private Long timestamp;

        public RateReadingHandler() {
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            try {
                if ("Cube".equals(qName)) {
                    if (attributes.getValue("time") != null) {
                        Date date = this.dateFormat.parse(attributes.getValue("time"));
                        this.timestamp = date.getTime();
                    } else if (attributes.getValue("currency") != null) {
                        CurrencyUnit tgtCurrency = MonetaryCurrencies.getCurrency((String)attributes.getValue("currency"));
                        ECBHistoric90RateProvider.this.addRate(tgtCurrency, this.timestamp, BigDecimal.valueOf(Double.parseDouble(attributes.getValue("rate"))));
                    }
                }
                super.startElement(uri, localName, qName, attributes);
            }
            catch (ParseException e) {
                throw new SAXException("Failed to read.", e);
            }
        }
    }
}

