/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.convert.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import javax.money.CurrencyUnit;
import javax.money.MonetaryCurrencies;
import javax.money.NumberValue;
import javax.money.convert.ConversionContext;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ProviderContext;
import javax.money.convert.RateType;
import javax.money.spi.Bootstrap;
import org.javamoney.moneta.BuildableCurrencyUnit;
import org.javamoney.moneta.spi.AbstractRateProvider;
import org.javamoney.moneta.spi.DefaultNumberValue;
import org.javamoney.moneta.spi.LoaderService;

public class IMFRateProvider
extends AbstractRateProvider
implements LoaderService.LoaderListener {
    private static final String DATA_ID = IMFRateProvider.class.getSimpleName();
    private static final ProviderContext CONTEXT = ((ProviderContext.Builder)((ProviderContext.Builder)new ProviderContext.Builder("IMF").setRateTypes(new RateType[]{RateType.DEFERRED}).set((Object)"Internation Monetary Fond", (Object)"providerDescription")).set((Object)1, (Object)"days")).create();
    private static final CurrencyUnit SDR = new BuildableCurrencyUnit.Builder("SDR").setDefaultFractionDigits(3).create(true);
    private Map<CurrencyUnit, List<ExchangeRate>> currencyToSdr = new HashMap<CurrencyUnit, List<ExchangeRate>>();
    private Map<CurrencyUnit, List<ExchangeRate>> sdrToCurrency = new HashMap<CurrencyUnit, List<ExchangeRate>>();
    private static Map<String, CurrencyUnit> currenciesByName = new HashMap<String, CurrencyUnit>();

    public IMFRateProvider() throws MalformedURLException {
        super(CONTEXT);
        LoaderService loader = (LoaderService)Bootstrap.getService(LoaderService.class);
        loader.addLoaderListener(this, DATA_ID);
        loader.loadDataAsync(DATA_ID);
    }

    @Override
    public void newDataLoaded(String data, InputStream is) {
        try {
            this.loadRatesTSV(is);
        }
        catch (Exception e) {
            this.LOGGER.log(Level.SEVERE, "Error", e);
        }
    }

    private void loadRatesTSV(InputStream inputStream) throws IOException, ParseException {
        HashMap<CurrencyUnit, List<ExchangeRate>> newCurrencyToSdr = new HashMap<CurrencyUnit, List<ExchangeRate>>();
        HashMap<CurrencyUnit, List<ExchangeRate>> newSdrToCurrency = new HashMap<CurrencyUnit, List<ExchangeRate>>();
        DecimalFormat f = new DecimalFormat("#0.0000000000");
        ((NumberFormat)f).setGroupingUsed(false);
        BufferedReader pr = new BufferedReader(new InputStreamReader(inputStream));
        String line = pr.readLine();
        boolean currencyToSdr = true;
        List<Long> timestamps = null;
        while (line != null) {
            if (line.trim().isEmpty()) {
                line = pr.readLine();
                continue;
            }
            if (line.startsWith("SDRs per Currency unit")) {
                currencyToSdr = false;
                line = pr.readLine();
                continue;
            }
            if (line.startsWith("Currency units per SDR")) {
                currencyToSdr = true;
                line = pr.readLine();
                continue;
            }
            if (line.startsWith("Currency")) {
                timestamps = this.readTimestamps(line);
                line = pr.readLine();
                continue;
            }
            String[] parts = line.split("\\t");
            CurrencyUnit currency = currenciesByName.get(parts[0]);
            if (currency == null) {
                this.LOGGER.warning("Unknown currency from, IMF data feed: " + parts[0]);
                line = pr.readLine();
                continue;
            }
            Double[] values = this.parseValues(f, parts);
            for (int i = 0; i < values.length; ++i) {
                ExchangeRate rate;
                List<ExchangeRate> rates;
                if (values[i] == null) continue;
                Long fromTS = timestamps.get(i);
                Long toTS = fromTS + 86400000L;
                RateType rateType = RateType.HISTORIC;
                if (toTS > System.currentTimeMillis()) {
                    rateType = RateType.DEFERRED;
                }
                if (currencyToSdr) {
                    rates = this.currencyToSdr.get(currency);
                    if (rates == null) {
                        rates = new ArrayList<ExchangeRate>(5);
                        newCurrencyToSdr.put(currency, rates);
                    }
                    rate = new ExchangeRate.Builder(ConversionContext.of((String)CONTEXT.getProviderName(), (RateType)rateType, (Long)toTS)).setBase(currency).setTerm(SDR).setFactor((NumberValue)new DefaultNumberValue(values[i])).create();
                    rates.add(rate);
                    continue;
                }
                rates = this.sdrToCurrency.get(currency);
                if (rates == null) {
                    rates = new ArrayList<ExchangeRate>(5);
                    newSdrToCurrency.put(currency, rates);
                }
                rate = new ExchangeRate.Builder(ConversionContext.of((String)CONTEXT.getProviderName(), (RateType)rateType, (Long)fromTS)).setBase(SDR).setTerm(currency).setFactor(DefaultNumberValue.of(values[i])).create();
                rates.add(rate);
            }
            line = pr.readLine();
        }
        for (List rateList : newSdrToCurrency.values()) {
            Collections.sort(rateList);
        }
        for (List rateList : newCurrencyToSdr.values()) {
            Collections.sort(rateList);
        }
        this.sdrToCurrency = newSdrToCurrency;
        this.currencyToSdr = newCurrencyToSdr;
    }

    private Double[] parseValues(NumberFormat f, String[] parts) throws ParseException {
        Double[] result = new Double[parts.length - 1];
        for (int i = 1; i < parts.length; ++i) {
            if (parts[i].isEmpty()) continue;
            result[i - 1] = f.parse(parts[i]).doubleValue();
        }
        return result;
    }

    private List<Long> readTimestamps(String line) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("MMM DD, yyyy", Locale.ENGLISH);
        String[] parts = line.split("\\\t");
        ArrayList<Long> dates = new ArrayList<Long>(parts.length);
        for (int i = 1; i < parts.length; ++i) {
            dates.add(sdf.parse(parts[i]).getTime());
        }
        return dates;
    }

    @Override
    protected ExchangeRate getExchangeRateInternal(CurrencyUnit base, CurrencyUnit term, ConversionContext context) {
        ExchangeRate rate1 = this.lookupRate(this.currencyToSdr.get(base), context.getTimestamp());
        ExchangeRate rate2 = this.lookupRate(this.sdrToCurrency.get(term), context.getTimestamp());
        if (base.equals(SDR)) {
            return rate2;
        }
        if (term.equals(SDR)) {
            return rate1;
        }
        if (rate1 == null || rate2 == null) {
            return null;
        }
        ExchangeRate.Builder builder = new ExchangeRate.Builder(ConversionContext.of((String)CONTEXT.getProviderName(), (RateType)RateType.HISTORIC));
        builder.setBase(base);
        builder.setTerm(term);
        builder.setFactor(IMFRateProvider.multiply(rate1.getFactor(), rate2.getFactor()));
        builder.setRateChain(new ExchangeRate[]{rate1, rate2});
        return builder.create();
    }

    private ExchangeRate lookupRate(List<ExchangeRate> list, Long timestamp) {
        if (list == null) {
            return null;
        }
        ExchangeRate found = null;
        for (ExchangeRate rate : list) {
            if (timestamp == null) {
                timestamp = System.currentTimeMillis();
            }
            if (rate.getConversionContext().isValid(timestamp.longValue())) {
                return rate;
            }
            if (found != null) continue;
            found = rate;
        }
        return found;
    }

    static {
        for (Currency currency : Currency.getAvailableCurrencies()) {
            currenciesByName.put(currency.getDisplayName(Locale.ENGLISH), MonetaryCurrencies.getCurrency((String)currency.getCurrencyCode()));
        }
        currenciesByName.put("U.K. Pound Sterling", MonetaryCurrencies.getCurrency((String)"GBP"));
        currenciesByName.put("U.S. Dollar", MonetaryCurrencies.getCurrency((String)"USD"));
        currenciesByName.put("Bahrain Dinar", MonetaryCurrencies.getCurrency((String)"BHD"));
        currenciesByName.put("Botswana Pula", MonetaryCurrencies.getCurrency((String)"BWP"));
        currenciesByName.put("Czech Koruna", MonetaryCurrencies.getCurrency((String)"CZK"));
        currenciesByName.put("Icelandic Krona", MonetaryCurrencies.getCurrency((String)"ISK"));
        currenciesByName.put("Korean Won", MonetaryCurrencies.getCurrency((String)"KRW"));
        currenciesByName.put("Rial Omani", MonetaryCurrencies.getCurrency((String)"OMR"));
        currenciesByName.put("Nuevo Sol", MonetaryCurrencies.getCurrency((String)"PEN"));
        currenciesByName.put("Qatar Riyal", MonetaryCurrencies.getCurrency((String)"QAR"));
        currenciesByName.put("Saudi Arabian Riyal", MonetaryCurrencies.getCurrency((String)"SAR"));
        currenciesByName.put("Sri Lanka Rupee", MonetaryCurrencies.getCurrency((String)"LKR"));
        currenciesByName.put("Trinidad And Tobago Dollar", MonetaryCurrencies.getCurrency((String)"TTD"));
        currenciesByName.put("U.A.E. Dirham", MonetaryCurrencies.getCurrency((String)"AED"));
        currenciesByName.put("Peso Uruguayo", MonetaryCurrencies.getCurrency((String)"UYU"));
        currenciesByName.put("Bolivar Fuerte", MonetaryCurrencies.getCurrency((String)"VEF"));
    }
}

