/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.format.internal;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.logging.Logger;
import javax.money.MonetaryAmount;
import javax.money.format.AmountFormatSymbols;
import javax.money.format.AmountStyle;
import javax.money.format.MonetaryParseException;
import org.javamoney.moneta.format.internal.FormatToken;
import org.javamoney.moneta.format.internal.ParseContext;
import org.javamoney.moneta.format.internal.StringGrouper;

final class AmountNumberToken
implements FormatToken {
    private AmountStyle style;
    private String partialNumberPattern;
    private DecimalFormat parseFormat;
    private DecimalFormat formatFormat;
    private StringGrouper numberGroup;

    public AmountNumberToken(AmountStyle style, String partialNumberPattern) {
        if (style == null) {
            throw new IllegalArgumentException("style is required.");
        }
        this.style = style;
        this.partialNumberPattern = partialNumberPattern;
        this.initDecimalFormats();
    }

    private void initDecimalFormats() {
        this.formatFormat = (DecimalFormat)DecimalFormat.getInstance(this.style.getLocale());
        this.parseFormat = (DecimalFormat)DecimalFormat.getInstance(this.style.getLocale());
        DecimalFormatSymbols symbols = this.formatFormat.getDecimalFormatSymbols();
        AmountFormatSymbols syms = this.style.getSymbols();
        if (syms != null) {
            symbols.setDecimalSeparator(syms.getDecimalSeparator().charValue());
            symbols.setDigit(syms.getDigit().charValue());
            symbols.setExponentSeparator(syms.getExponentSeparator());
            symbols.setMinusSign(syms.getMinusSign().charValue());
            symbols.setPatternSeparator(syms.getPatternSeparator().charValue());
            symbols.setZeroDigit(syms.getZeroDigit().charValue());
            this.formatFormat.setDecimalFormatSymbols(symbols);
            this.parseFormat.setDecimalFormatSymbols(symbols);
        }
        this.formatFormat.applyPattern(this.partialNumberPattern);
        this.parseFormat.applyPattern(this.partialNumberPattern.trim());
    }

    public AmountStyle getAmountStyle() {
        return this.style;
    }

    public String getNumberPattern() {
        return this.partialNumberPattern;
    }

    @Override
    public void print(Appendable appendable, MonetaryAmount amount) throws IOException {
        int digits = amount.getCurrency().getDefaultFractionDigits();
        this.formatFormat.setMinimumFractionDigits(digits);
        this.formatFormat.setMaximumFractionDigits(digits);
        if (this.style.getGroupingSizes().length == 0) {
            appendable.append(this.formatFormat.format(amount.getNumber().numberValue(BigDecimal.class)));
            return;
        }
        this.formatFormat.setGroupingUsed(false);
        String preformattedValue = this.formatFormat.format(amount.getNumber().numberValue(BigDecimal.class));
        String[] numberParts = this.splitNumberParts(this.formatFormat, preformattedValue);
        if (numberParts.length != 2) {
            appendable.append(preformattedValue);
        } else {
            if (this.numberGroup == null) {
                char[] groupChars = this.style.getSymbols().getGroupingSeparators();
                if (groupChars.length == 0) {
                    groupChars = new char[]{this.formatFormat.getDecimalFormatSymbols().getGroupingSeparator()};
                }
                this.numberGroup = new StringGrouper(groupChars, this.style.getGroupingSizes());
            }
            preformattedValue = this.numberGroup.group(numberParts[0]) + this.formatFormat.getDecimalFormatSymbols().getDecimalSeparator() + numberParts[1];
            appendable.append(preformattedValue);
        }
    }

    private String[] splitNumberParts(DecimalFormat format, String preformattedValue) {
        int index = preformattedValue.indexOf(format.getDecimalFormatSymbols().getDecimalSeparator());
        if (index < 0) {
            return new String[]{preformattedValue};
        }
        return new String[]{preformattedValue.substring(0, index), preformattedValue.substring(index + 1)};
    }

    @Override
    public void parse(ParseContext context) throws MonetaryParseException {
        String token = context.lookupNextToken();
        if (token != null && !context.isComplete()) {
            this.parseToken(context, token);
            if (context.hasError()) {
                throw new MonetaryParseException(context.getErrorMessage(), context.getInput(), context.getIndex());
            }
        } else {
            context.setError();
            context.setErrorMessage("Number expected.");
        }
    }

    private void parseToken(ParseContext context, String token) {
        try {
            Number number = this.parseFormat.parse(token);
            if (number != null) {
                context.setParsedNumber(number);
                context.consume(token);
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).finest("Could not parse amount from: " + token);
            context.setError();
            context.setErrorMessage(e.getMessage());
        }
    }
}

