/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.format.internal;

import java.io.IOException;
import java.util.Currency;
import java.util.Locale;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryCurrencies;
import javax.money.format.CurrencyStyle;
import javax.money.format.MonetaryParseException;
import org.javamoney.moneta.format.internal.FormatToken;
import org.javamoney.moneta.format.internal.ParseContext;

final class CurrencyToken
implements FormatToken {
    private CurrencyStyle style = CurrencyStyle.CODE;
    private Locale locale;

    public CurrencyToken(CurrencyStyle style, Locale locale) {
        this.locale = locale;
    }

    public CurrencyToken setCurrencyStyle(CurrencyStyle displayType) {
        if (displayType == null) {
            throw new IllegalArgumentException("Display type null.");
        }
        this.style = displayType;
        return this;
    }

    public CurrencyStyle getCurrencyStyle() {
        return this.style;
    }

    protected String getToken(MonetaryAmount amount) {
        switch (this.style) {
            case NUMERIC_CODE: {
                return String.valueOf(amount.getCurrency().getNumericCode());
            }
            case NAME: {
                return this.getCurrencyName(amount.getCurrency());
            }
            case SYMBOL: {
                return this.getCurrencySymbol(amount.getCurrency());
            }
        }
        return amount.getCurrency().getCurrencyCode();
    }

    private String getCurrencyName(CurrencyUnit currency) {
        Currency jdkCurrency = this.getCurrency(currency.getCurrencyCode());
        if (jdkCurrency != null) {
            return jdkCurrency.getDisplayName(this.locale);
        }
        return currency.getCurrencyCode();
    }

    private Currency getCurrency(String currencyCode) {
        try {
            return Currency.getInstance(currencyCode);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getCurrencySymbol(CurrencyUnit currency) {
        Currency jdkCurrency = this.getCurrency(currency.getCurrencyCode());
        if (jdkCurrency != null) {
            return jdkCurrency.getSymbol(this.locale);
        }
        return currency.getCurrencyCode();
    }

    @Override
    public void parse(ParseContext context) throws MonetaryParseException {
        String token = context.lookupNextToken();
        while (token != null && token.trim().isEmpty()) {
            context.consume(token);
            token = context.lookupNextToken();
        }
        try {
            CurrencyUnit cur = null;
            switch (this.style) {
                case CODE: {
                    cur = MonetaryCurrencies.getCurrency((String)token);
                    context.consume(token);
                    break;
                }
                case SYMBOL: {
                    if (token.startsWith("$")) {
                        cur = MonetaryCurrencies.getCurrency((String)"USD");
                        context.consume("$");
                    } else if (token.startsWith("\u20ac")) {
                        cur = MonetaryCurrencies.getCurrency((String)"EUR");
                        context.consume("\u20ac");
                    } else if (token.startsWith("\u00a3")) {
                        cur = MonetaryCurrencies.getCurrency((String)"GBP");
                        context.consume("\u00a3");
                    }
                    cur = MonetaryCurrencies.getCurrency((String)token);
                    context.consume(token);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Not yet implemented");
                }
            }
            if (cur != null) {
                context.setParsedCurrency(cur);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void print(Appendable appendable, MonetaryAmount amount) throws IOException {
        appendable.append(this.getToken(amount));
    }

    public String toString() {
        return "CurrencyToken [locale=" + this.locale + ", style=" + this.style + "]";
    }
}

