/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.format.internal;

final class StringGrouper {
    private char[] groupCharacters = new char[]{' '};
    private int[] groupSizes = new int[]{3};
    private boolean reverse;

    public StringGrouper() {
    }

    public StringGrouper(char ... groupCharacters) {
        this.setGroupChars(groupCharacters);
    }

    public StringGrouper(char groupCharacter, int ... groupSizes) {
        this.setGroupChars(groupCharacter);
        this.setGroupSizes(groupSizes);
    }

    public StringGrouper(char[] groupCharacters, int ... groupSizes) {
        this.setGroupChars(groupCharacters);
        this.setGroupSizes(groupSizes);
    }

    public StringGrouper setGroupChars(char ... groupCharacters) {
        if (groupCharacters == null) {
            throw new IllegalArgumentException("groupCharacters is required.");
        }
        this.groupCharacters = (char[])groupCharacters.clone();
        return this;
    }

    public char[] getGroupChars() {
        return (char[])this.groupCharacters.clone();
    }

    public int[] getGroupSizes() {
        return (int[])this.groupSizes.clone();
    }

    public StringGrouper setGroupSizes(int ... groupSizes) {
        if (groupSizes == null) {
            throw new IllegalArgumentException("groupSizes is required.");
        }
        this.groupSizes = (int[])groupSizes.clone();
        return this;
    }

    public StringGrouper setReverse(boolean reverse) {
        this.reverse = reverse;
        return this;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public String group(String input) {
        char[] inputArr;
        StringBuilder builder = new StringBuilder(4);
        String start = null;
        String end = null;
        for (char ch : inputArr = input.toCharArray()) {
            if (Character.isDigit(ch)) break;
            builder.append(ch);
        }
        start = builder.toString();
        builder.setLength(0);
        for (int i = inputArr.length - 1; i >= 0 && !Character.isDigit(inputArr[i]); --i) {
            builder.insert(0, inputArr[i]);
        }
        end = builder.toString();
        builder.setLength(0);
        builder.append(start);
        builder.append(this.groupNumeric(input.substring(start.length(), input.length() - end.length())));
        builder.append(end);
        return builder.toString();
    }

    public String groupNumeric(String input) {
        if (this.groupSizes.length == 0 || this.groupCharacters.length == 0) {
            return input;
        }
        if (this.reverse) {
            return this.formatInternalReverse(input);
        }
        int groupIndex = 0;
        int sizeIndex = 0;
        char groupChar = this.groupCharacters[groupIndex];
        int groupSize = this.groupSizes[sizeIndex];
        if (groupSize <= 0) {
            return input;
        }
        char[] group = new char[groupSize];
        StringBuilder result = new StringBuilder(input.length() + 4);
        for (int pos = input.length(); pos > 0; pos -= groupSize) {
            if (groupSize == 0) {
                return input;
            }
            int start = pos - groupSize;
            if (result.length() != 0) {
                result.insert(0, groupChar);
                if (groupIndex < this.groupCharacters.length - 1) {
                    groupChar = this.groupCharacters[++groupIndex];
                }
            }
            if (start >= 0) {
                input.getChars(start, pos, group, 0);
                result.insert(0, group, 0, groupSize);
                if (sizeIndex >= this.groupSizes.length - 1 || (groupSize = this.groupSizes[++sizeIndex]) <= group.length) continue;
                group = new char[groupSize];
                continue;
            }
            input.getChars(0, pos, group, 0);
            result.insert(0, group, 0, pos);
            break;
        }
        return result.toString();
    }

    private String formatInternalReverse(String input) {
        int groupIndex = 0;
        int sizeIndex = 0;
        char groupChar = this.groupCharacters[groupIndex];
        int groupSize = this.groupSizes[sizeIndex];
        if (groupSize <= 0) {
            return input;
        }
        char[] group = new char[groupSize];
        StringBuilder result = new StringBuilder(input.length() + 4);
        for (int pos = 0; pos < input.length(); pos += groupSize) {
            if (groupSize == 0) {
                return input;
            }
            int end = pos + groupSize;
            if (result.length() != 0) {
                result.append(groupChar);
                if (groupIndex < this.groupCharacters.length - 1) {
                    groupChar = this.groupCharacters[++groupIndex];
                }
            }
            if (end <= input.length()) {
                input.getChars(pos, end, group, 0);
                result.append(group, 0, groupSize);
                if (sizeIndex >= this.groupSizes.length - 1 || (groupSize = this.groupSizes[++sizeIndex]) <= group.length) continue;
                group = new char[groupSize];
                continue;
            }
            input.getChars(pos, input.length(), group, 0);
            result.append(group, 0, input.length() - pos);
            break;
        }
        return result.toString();
    }
}

