/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.function;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.concurrent.atomic.AtomicLong;
import javax.money.MonetaryOperator;
import javax.money.MonetaryQuery;
import org.javamoney.moneta.function.MajorPart;
import org.javamoney.moneta.function.MajorUnits;
import org.javamoney.moneta.function.MinorPart;
import org.javamoney.moneta.function.MinorUnits;
import org.javamoney.moneta.function.Percent;
import org.javamoney.moneta.function.Permil;
import org.javamoney.moneta.function.Reciprocal;

public final class MonetaryFunctions {
    private static final MathContext DEFAULT_MATH_CONTEXT = MonetaryFunctions.initDefaultMathContext();
    private static final Reciprocal RECIPROCAL = new Reciprocal();
    private static final MinorPart MINORPART = new MinorPart();
    private static final MinorUnits MINORUNITS = new MinorUnits();
    private static final MajorPart MAJORPART = new MajorPart();
    private static final MajorUnits MAJORUNITS = new MajorUnits();

    private MonetaryFunctions() {
    }

    private static MathContext initDefaultMathContext() {
        return MathContext.DECIMAL64;
    }

    public static MonetaryOperator reciprocal() {
        return RECIPROCAL;
    }

    public static MonetaryOperator permil(BigDecimal decimal) {
        return new Permil(decimal);
    }

    public static MonetaryOperator permil(Number number) {
        return MonetaryFunctions.permil(number, DEFAULT_MATH_CONTEXT);
    }

    public static MonetaryOperator permil(Number number, MathContext mathContext) {
        return new Permil(MonetaryFunctions.getBigDecimal(number, mathContext));
    }

    private static final BigDecimal getBigDecimal(Number num, MathContext mathContext) {
        if (num instanceof BigDecimal) {
            return (BigDecimal)num;
        }
        if (num instanceof Long || num instanceof Integer || num instanceof Byte || num instanceof AtomicLong) {
            return BigDecimal.valueOf(num.longValue());
        }
        if (num instanceof Float || num instanceof Double) {
            return new BigDecimal(num.toString());
        }
        try {
            return new BigDecimal(num.toString(), mathContext);
        }
        catch (NumberFormatException numberFormatException) {
            return BigDecimal.valueOf(num.doubleValue());
        }
    }

    public static MonetaryOperator percent(BigDecimal decimal) {
        return new Percent(decimal);
    }

    public static MonetaryOperator percent(Number number) {
        return MonetaryFunctions.percent(MonetaryFunctions.getBigDecimal(number, DEFAULT_MATH_CONTEXT));
    }

    public static MonetaryOperator minorPart() {
        return MINORPART;
    }

    public static MonetaryOperator majorPart() {
        return MAJORPART;
    }

    public static MonetaryQuery<Long> minorUnits() {
        return MINORUNITS;
    }

    public static MonetaryQuery<Long> majorUnits() {
        return MAJORUNITS;
    }
}

