/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.function;

import java.math.BigDecimal;
import java.math.MathContext;
import java.text.NumberFormat;
import java.util.Locale;
import javax.money.MonetaryAmount;
import javax.money.MonetaryOperator;

final class Percent
implements MonetaryOperator {
    private static final BigDecimal ONE_HUNDRED = new BigDecimal(100, MathContext.DECIMAL64);
    private final BigDecimal percentValue;

    Percent(BigDecimal decimal) {
        this.percentValue = Percent.calcPercent(decimal);
    }

    public <T extends MonetaryAmount> T apply(T amount) {
        return (T)amount.multiply((Number)this.percentValue);
    }

    public String toString() {
        return NumberFormat.getPercentInstance().format(this.percentValue);
    }

    public String getDisplayName(Locale locale) {
        return NumberFormat.getPercentInstance(locale).format(this.percentValue);
    }

    private static final BigDecimal calcPercent(BigDecimal decimal) {
        return decimal.divide(ONE_HUNDRED, MathContext.DECIMAL64);
    }
}

