/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.money.CurrencyUnit;
import javax.money.spi.CurrencyProviderSpi;

public class ConfigurableCurrencyUnitProvider
implements CurrencyProviderSpi {
    private static Map<String, CurrencyUnit> currencyUnits = new ConcurrentHashMap<String, CurrencyUnit>();
    private static Map<Locale, CurrencyUnit> currencyUnitsByLocale = new ConcurrentHashMap<Locale, CurrencyUnit>();

    public CurrencyUnit getCurrencyUnit(String currencyCode) {
        return currencyUnits.get(currencyCode);
    }

    public CurrencyUnit getCurrencyUnit(Locale locale) {
        return currencyUnitsByLocale.get(locale);
    }

    public static CurrencyUnit registerCurrencyUnit(CurrencyUnit currencyUnit) {
        Objects.requireNonNull(currencyUnit);
        return currencyUnits.put(currencyUnit.getCurrencyCode(), currencyUnit);
    }

    public static CurrencyUnit registerCurrencyUnit(CurrencyUnit currencyUnit, Locale locale) {
        Objects.requireNonNull(locale);
        Objects.requireNonNull(currencyUnit);
        return currencyUnitsByLocale.put(locale, currencyUnit);
    }

    public static CurrencyUnit removeCurrencyUnit(String currencyCode) {
        Objects.requireNonNull(currencyCode);
        return currencyUnits.remove(currencyCode);
    }

    public static CurrencyUnit removeCurrencyUnit(Locale locale) {
        Objects.requireNonNull(locale);
        return currencyUnitsByLocale.remove(locale);
    }

    public String toString() {
        return "ConfigurableCurrencyUnitProvider [currencyUnits=" + currencyUnits + ", currencyUnitsByLocale=" + currencyUnitsByLocale + "]";
    }
}

