/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal;

import java.math.RoundingMode;
import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryCurrencies;
import javax.money.MonetaryOperator;

final class DefaultCashRounding
implements MonetaryOperator {
    private final RoundingMode roundingMode;
    private final int scale;

    DefaultCashRounding(int scale, RoundingMode roundingMode) {
        if (scale < 0) {
            throw new IllegalArgumentException("scale < 0");
        }
        if (roundingMode == null) {
            throw new IllegalArgumentException("roundingMode missing");
        }
        this.scale = scale;
        this.roundingMode = roundingMode;
    }

    DefaultCashRounding(CurrencyUnit currency, RoundingMode roundingMode) {
        this(MonetaryCurrencies.getCurrency((String)currency.getCurrencyCode()).getDefaultFractionDigits(), roundingMode);
    }

    DefaultCashRounding(CurrencyUnit currency) {
        this(MonetaryCurrencies.getCurrency((String)currency.getCurrencyCode()).getDefaultFractionDigits(), RoundingMode.HALF_UP);
    }

    public <T extends MonetaryAmount> T apply(T value) {
        Objects.requireNonNull(value, "Amount required.");
        throw new UnsupportedOperationException("Cash Rounding not yet implemented.");
    }
}

