/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryContext;
import javax.money.MonetaryException;
import javax.money.spi.Bootstrap;
import javax.money.spi.MonetaryAmountFactoryProviderSpi;
import javax.money.spi.MonetaryAmountsSpi;
import org.javamoney.moneta.ServicePriority;

public class DefaultMonetaryAmountsSpi
implements MonetaryAmountsSpi {
    private Map<Class<? extends MonetaryAmount>, MonetaryAmountFactoryProviderSpi<?>> factories = new ConcurrentHashMap();
    private Class<? extends MonetaryAmount> configuredDefaultAmountType = this.loadDefaultAmountType();
    private static final Comparator<MonetaryAmountFactoryProviderSpi<? extends MonetaryAmount>> CONTEXT_COMPARATOR = new Comparator<MonetaryAmountFactoryProviderSpi<? extends MonetaryAmount>>(){

        @Override
        public int compare(MonetaryAmountFactoryProviderSpi<? extends MonetaryAmount> f1, MonetaryAmountFactoryProviderSpi<? extends MonetaryAmount> f2) {
            int compare = 0;
            MonetaryContext c1 = f1.getMaximalMonetaryContext();
            MonetaryContext c2 = f2.getMaximalMonetaryContext();
            if (c1.getAmountFlavor() == MonetaryContext.AmountFlavor.PRECISION && c2.getAmountFlavor() != MonetaryContext.AmountFlavor.PRECISION) {
                compare = -1;
            }
            if (compare == 0 && c2.getAmountFlavor() == MonetaryContext.AmountFlavor.PRECISION && c1.getAmountFlavor() != MonetaryContext.AmountFlavor.PRECISION) {
                compare = 1;
            }
            if (compare == 0 && c1.getPrecision() == 0 && c2.getPrecision() != 0) {
                compare = -1;
            }
            if (compare == 0 && c2.getPrecision() == 0 && c1.getPrecision() != 0) {
                compare = 1;
            }
            if (compare == 0 && c1.getMaxScale() > c2.getMaxScale()) {
                compare = -1;
            }
            if (compare == 0 && c1.getMaxScale() < c2.getMaxScale()) {
                compare = 1;
            }
            return compare;
        }
    };

    public DefaultMonetaryAmountsSpi() {
        for (MonetaryAmountFactoryProviderSpi f : Bootstrap.getServices(MonetaryAmountFactoryProviderSpi.class)) {
            MonetaryAmountFactoryProviderSpi existing = this.factories.put(f.getAmountType(), f);
            if (existing == null) continue;
            int compare = DefaultMonetaryAmountsSpi.comparePriority(existing, f);
            if (compare < 0) {
                Logger.getLogger(this.getClass().getName()).warning("MonetaryAmountFactoryProviderSpi with lower prio ignored: " + f);
                this.factories.put(f.getAmountType(), existing);
                continue;
            }
            if (compare != 0) continue;
            throw new IllegalStateException("Ambigous MonetaryAmountFactoryProviderSpi found for " + f.getAmountType() + ": " + f.getClass().getName() + '/' + existing.getClass().getName());
        }
    }

    private static int getServicePriority(Object service) {
        if (service == null) {
            return Integer.MIN_VALUE;
        }
        ServicePriority prio = service.getClass().getAnnotation(ServicePriority.class);
        if (prio != null) {
            return prio.value();
        }
        return 0;
    }

    public static <T> int comparePriority(T service1, T service2) {
        return DefaultMonetaryAmountsSpi.getServicePriority(service2) - DefaultMonetaryAmountsSpi.getServicePriority(service1);
    }

    private Class<? extends MonetaryAmount> loadDefaultAmountType() {
        return null;
    }

    public <T extends MonetaryAmount> MonetaryAmountFactory<T> getAmountFactory(Class<T> amountType) {
        MonetaryAmountFactoryProviderSpi f = (MonetaryAmountFactoryProviderSpi)MonetaryAmountFactoryProviderSpi.class.cast(this.factories.get(amountType));
        if (f != null) {
            return f.createMonetaryAmountFactory();
        }
        throw new MonetaryException("No matching MonetaryAmountFactory found, type=" + amountType.getName());
    }

    public Set<Class<? extends MonetaryAmount>> getAmountTypes() {
        return this.factories.keySet();
    }

    public Class<? extends MonetaryAmount> getDefaultAmountType() {
        Iterator i$;
        if (this.configuredDefaultAmountType == null && (i$ = Bootstrap.getServices(MonetaryAmountFactoryProviderSpi.class).iterator()).hasNext()) {
            MonetaryAmountFactoryProviderSpi f = (MonetaryAmountFactoryProviderSpi)i$.next();
            this.configuredDefaultAmountType = f.getAmountType();
        }
        if (this.configuredDefaultAmountType == null) {
            throw new MonetaryException("No MonetaryAmountFactoryProviderSpi registered.");
        }
        return this.configuredDefaultAmountType;
    }

    public Class<? extends MonetaryAmount> queryAmountType(MonetaryContext requiredContext) {
        if (requiredContext == null) {
            return this.getDefaultAmountType();
        }
        for (MonetaryAmountFactoryProviderSpi f : Bootstrap.getServices(MonetaryAmountFactoryProviderSpi.class)) {
            if (f.getQueryInclusionPolicy() == MonetaryAmountFactoryProviderSpi.QueryInclusionPolicy.NEVER || requiredContext.getAmountType() != f.getAmountType()) continue;
            if (this.isPrecisionOK(requiredContext, f.getMaximalMonetaryContext())) {
                return f.getAmountType();
            }
            throw new MonetaryException("Incompatible context required=" + requiredContext + ", maximal=" + f.getMaximalMonetaryContext());
        }
        ArrayList<MonetaryAmountFactoryProviderSpi> selection = new ArrayList<MonetaryAmountFactoryProviderSpi>();
        for (MonetaryAmountFactoryProviderSpi f : Bootstrap.getServices(MonetaryAmountFactoryProviderSpi.class)) {
            if (f.getDefaultMonetaryContext().getAmountFlavor() == MonetaryContext.AmountFlavor.UNDEFINED) {
                if (f.getQueryInclusionPolicy() == MonetaryAmountFactoryProviderSpi.QueryInclusionPolicy.DIRECT_REFERENCE_ONLY || f.getQueryInclusionPolicy() == MonetaryAmountFactoryProviderSpi.QueryInclusionPolicy.NEVER || !this.isPrecisionOK(requiredContext, f.getMaximalMonetaryContext())) continue;
                selection.add(f);
                continue;
            }
            if (requiredContext.getAmountFlavor() != f.getDefaultMonetaryContext().getAmountFlavor() || !this.isPrecisionOK(requiredContext, f.getMaximalMonetaryContext())) continue;
            selection.add(f);
        }
        if (selection.isEmpty()) {
            for (MonetaryAmountFactoryProviderSpi f : Bootstrap.getServices(MonetaryAmountFactoryProviderSpi.class)) {
                if (f.getQueryInclusionPolicy() == MonetaryAmountFactoryProviderSpi.QueryInclusionPolicy.DIRECT_REFERENCE_ONLY || f.getQueryInclusionPolicy() == MonetaryAmountFactoryProviderSpi.QueryInclusionPolicy.NEVER || !this.isPrecisionOK(requiredContext, f.getMaximalMonetaryContext())) continue;
                selection.add(f);
            }
        }
        if (selection.size() == 1) {
            return ((MonetaryAmountFactoryProviderSpi)selection.get(0)).getAmountType();
        }
        for (MonetaryAmountFactoryProviderSpi f : selection) {
            if (!f.getDefaultMonetaryContext().getAmountFlavor().equals((Object)requiredContext.getAmountFlavor())) continue;
            return f.getAmountType();
        }
        Collections.sort(selection, CONTEXT_COMPARATOR);
        return ((MonetaryAmountFactoryProviderSpi)selection.get(0)).getAmountType();
    }

    private boolean isPrecisionOK(MonetaryContext requiredContext, MonetaryContext maximalMonetaryContext) {
        if (maximalMonetaryContext.getPrecision() == 0) {
            return true;
        }
        if (requiredContext.getPrecision() == 0 && maximalMonetaryContext.getPrecision() != 0) {
            return false;
        }
        if (requiredContext.getPrecision() > maximalMonetaryContext.getPrecision()) {
            return false;
        }
        return requiredContext.getMaxScale() <= maximalMonetaryContext.getMaxScale();
    }

    public static final class ProviderComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object p1, Object p2) {
            return DefaultMonetaryAmountsSpi.comparePriority(p1, p2);
        }
    }
}

