/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryCurrencies;
import javax.money.MonetaryOperator;

final class DefaultRounding
implements MonetaryOperator {
    private final RoundingMode roundingMode;
    private final int scale;

    DefaultRounding(int scale, RoundingMode roundingMode) {
        Objects.requireNonNull(roundingMode, "RoundingMode required.");
        if (scale < 0) {
            scale = 0;
        }
        this.scale = scale;
        this.roundingMode = roundingMode;
    }

    DefaultRounding(CurrencyUnit currency, RoundingMode roundingMode) {
        this(currency.getDefaultFractionDigits(), roundingMode);
    }

    DefaultRounding(CurrencyUnit currency) {
        this(MonetaryCurrencies.getCurrency((String)currency.getCurrencyCode()).getDefaultFractionDigits(), RoundingMode.HALF_UP);
    }

    public <T extends MonetaryAmount> T apply(T amount) {
        return (T)amount.getFactory().setCurrency(amount.getCurrency()).setNumber((Number)((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)).setScale(this.scale, this.roundingMode)).create();
    }
}

