/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal;

import java.math.RoundingMode;
import java.util.Collections;
import java.util.Set;
import javax.money.CurrencyUnit;
import javax.money.MonetaryContext;
import javax.money.MonetaryOperator;
import javax.money.spi.RoundingProviderSpi;
import org.javamoney.moneta.internal.DefaultCashRounding;
import org.javamoney.moneta.internal.DefaultRounding;

public class DefaultRoundingProvider
implements RoundingProviderSpi {
    public MonetaryOperator getRounding(CurrencyUnit currency) {
        return new DefaultRounding(currency);
    }

    public MonetaryOperator getRounding(CurrencyUnit currency, long timestamp) {
        return null;
    }

    public MonetaryOperator getCashRounding(CurrencyUnit currency) {
        return new DefaultCashRounding(currency);
    }

    public MonetaryOperator getCashRounding(CurrencyUnit currency, long timestamp) {
        return null;
    }

    public Set<String> getCustomRoundingIds() {
        return Collections.emptySet();
    }

    public MonetaryOperator getCustomRounding(String customRoundingId) {
        throw new IllegalArgumentException("No such custom rounding: " + customRoundingId);
    }

    public MonetaryOperator getRounding(MonetaryContext monetaryContext) {
        RoundingMode rm = (RoundingMode)((Object)monetaryContext.getAttribute(RoundingMode.class, (Object)RoundingMode.HALF_EVEN));
        return new DefaultRounding(monetaryContext.getMaxScale(), rm);
    }
}

