/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal;

import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.CurrencyUnit;
import javax.money.spi.CurrencyProviderSpi;
import org.javamoney.moneta.internal.JDKCurrencyAdapter;

public class JDKCurrencyProvider
implements CurrencyProviderSpi {
    private static final Map<String, CurrencyUnit> CACHED = new HashMap<String, CurrencyUnit>();

    public JDKCurrencyProvider() {
        for (Currency jdkCurrency : Currency.getAvailableCurrencies()) {
            JDKCurrencyAdapter cu = new JDKCurrencyAdapter(jdkCurrency);
            CACHED.put(cu.getCurrencyCode(), cu);
        }
    }

    public CurrencyUnit getCurrencyUnit(String currencyCode) {
        return CACHED.get(currencyCode);
    }

    public CurrencyUnit getCurrencyUnit(Locale locale) {
        block3: {
            Currency cur = null;
            try {
                cur = Currency.getInstance(locale);
                if (cur != null) {
                    return this.getCurrencyUnit(cur.getCurrencyCode());
                }
            }
            catch (Exception e) {
                if (!Logger.getLogger(this.getClass().getName()).isLoggable(Level.FINEST)) break block3;
                Logger.getLogger(this.getClass().getName()).finest("No currency for locale found: " + locale);
            }
        }
        return null;
    }
}

