/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal;

import java.math.RoundingMode;
import javax.money.CurrencyUnit;
import javax.money.MonetaryContext;
import org.javamoney.moneta.Money;
import org.javamoney.moneta.spi.AbstractAmountFactory;

public class MoneyAmountFactory
extends AbstractAmountFactory<Money> {
    static final MonetaryContext DEFAULT_CONTEXT = ((MonetaryContext.Builder)new MonetaryContext.Builder(Money.class).setPrecision(64).setMaxScale(63).set((Object)RoundingMode.HALF_EVEN)).setFlavor(MonetaryContext.AmountFlavor.PRECISION).create();
    static final MonetaryContext MAX_CONTEXT = ((MonetaryContext.Builder)new MonetaryContext.Builder(Money.class).setPrecision(0).setMaxScale(-1).set((Object)RoundingMode.HALF_EVEN)).setFlavor(MonetaryContext.AmountFlavor.PRECISION).create();

    @Override
    protected Money create(CurrencyUnit currency, Number number, MonetaryContext monetaryContext) {
        return Money.of(currency, number, MonetaryContext.from((MonetaryContext)monetaryContext, Money.class));
    }

    public Class<Money> getAmountType() {
        return Money.class;
    }

    @Override
    protected MonetaryContext loadDefaultMonetaryContext() {
        return DEFAULT_CONTEXT;
    }

    @Override
    protected MonetaryContext loadMaxMonetaryContext() {
        return MAX_CONTEXT;
    }
}

