/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.loader.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javamoney.moneta.spi.LoaderService;

public class LoadableResource {
    private static final Logger LOG = Logger.getLogger(LoadableResource.class.getName());
    private final Object LOCK = new Object();
    private String resourceId;
    private LoaderService.UpdatePolicy updatePolicy;
    private List<URL> remoteResources = new ArrayList<URL>();
    private URL fallbackLocation;
    private URL cachedResource;
    private AtomicInteger loadCount = new AtomicInteger();
    private AtomicInteger accessCount = new AtomicInteger();
    private volatile byte[] data;
    private long lastLoaded;
    private Map<String, String> updateConfig;

    public LoadableResource(String resourceId, LoaderService.UpdatePolicy updatePolicy, URL fallbackLocation, URL ... locations) {
        Objects.requireNonNull(resourceId, "resourceId required");
        Objects.requireNonNull(fallbackLocation, "classpathDefault required");
        Objects.requireNonNull(updatePolicy, "UpdatePolicy required");
        this.resourceId = resourceId;
        this.fallbackLocation = fallbackLocation;
        this.remoteResources.addAll(Arrays.asList(locations));
        this.updatePolicy = updatePolicy;
    }

    public boolean load() {
        if (!this.loadRemote()) {
            return this.loadFallback();
        }
        return true;
    }

    public final String getResourceId() {
        return this.resourceId;
    }

    public LoaderService.UpdatePolicy getUpdatePolicy() {
        return this.updatePolicy;
    }

    public final List<URL> getRemoteResources() {
        return Collections.unmodifiableList(this.remoteResources);
    }

    public final URL getFallbackResource() {
        return this.fallbackLocation;
    }

    public final URL getCachedResource() {
        return this.cachedResource;
    }

    public final int getLoadCount() {
        return this.loadCount.get();
    }

    public final int getAccessCount() {
        return this.accessCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] getData() {
        this.accessCount.incrementAndGet();
        if (this.data == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.data == null && !this.loadRemote()) {
                    this.loadFallback();
                }
                if (this.data == null) {
                    throw new IllegalStateException("Failed to load remote as well as fallback resources for " + this);
                }
            }
        }
        return (byte[])this.data.clone();
    }

    public InputStream getDataStream() {
        return new WrappedInputStream(new ByteArrayInputStream(this.getData()));
    }

    public final long getLastLoaded() {
        return this.lastLoaded;
    }

    public boolean loadRemote() {
        for (URL itemToLoad : this.remoteResources) {
            try {
                this.load(itemToLoad, false);
                return true;
            }
            catch (Exception e) {
                LOG.log(Level.INFO, "Failed to load resource: " + itemToLoad, e);
            }
        }
        return false;
    }

    public boolean loadFallback() {
        try {
            this.load(this.fallbackLocation, true);
            return true;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to load fallback resource: " + this.fallbackLocation, e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(URL itemToLoad, boolean fallbackLoad) throws IOException {
        InputStream is = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            URLConnection conn = itemToLoad.openConnection();
            byte[] data = new byte[4096];
            is = conn.getInputStream();
            int read = is.read(data);
            while (read > 0) {
                bos.write(data, 0, read);
                read = is.read(data);
            }
            this.data = bos.toByteArray();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Error closing resource input for " + this.resourceId, e);
                }
            }
            if (bos != null) {
                bos.close();
            }
        }
        if (!fallbackLoad) {
            this.lastLoaded = System.currentTimeMillis();
            this.loadCount.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload() {
        Object object = this.LOCK;
        synchronized (object) {
            int count = this.accessCount.decrementAndGet();
            if (count == 0) {
                this.data = null;
            }
        }
    }

    public boolean reset() throws IOException {
        if (this.loadFallback()) {
            this.loadCount.set(0);
            return true;
        }
        return false;
    }

    public Map<String, String> getUpdateConfig() {
        return this.updateConfig;
    }

    public String toString() {
        return "LoadableResource [resourceId=" + this.resourceId + ", updatePolicy=" + (Object)((Object)this.updatePolicy) + ", fallbackLocation=" + this.fallbackLocation + ", remoteResources=" + this.remoteResources + ", cachedResource=" + this.cachedResource + ", loadCount=" + this.loadCount + ", accessCount=" + this.accessCount + ", lastLoaded=" + this.lastLoaded + ", updateConfig=" + this.updateConfig + "]";
    }

    private final class WrappedInputStream
    extends InputStream {
        private InputStream wrapped;

        public WrappedInputStream(InputStream wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public int read() throws IOException {
            return this.wrapped.read();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                this.wrapped.close();
                super.close();
            }
            finally {
                LoadableResource.this.unload();
            }
        }
    }
}

