/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryContext;
import javax.money.MonetaryCurrencies;

public abstract class AbstractAmountFactory<T extends MonetaryAmount>
implements MonetaryAmountFactory<T> {
    private MonetaryContext DEFAULT_MONETARY_CONTEXT = this.loadDefaultMonetaryContext();
    private MonetaryContext MAX_MONETARY_CONTEXT = this.loadMaxMonetaryContext();
    private CurrencyUnit currency;
    private Number number;
    private MonetaryContext monetaryContext = this.DEFAULT_MONETARY_CONTEXT;

    public T create() {
        return this.create(this.currency, this.number, this.monetaryContext);
    }

    protected abstract T create(CurrencyUnit var1, Number var2, MonetaryContext var3);

    protected abstract MonetaryContext loadDefaultMonetaryContext();

    protected abstract MonetaryContext loadMaxMonetaryContext();

    public MonetaryAmountFactory<T> setCurrency(CurrencyUnit currency) {
        Objects.requireNonNull(currency);
        this.currency = currency;
        return this;
    }

    public MonetaryAmountFactory<T> setNumber(Number number) {
        this.number = AbstractAmountFactory.getBigDecimal(number);
        return this;
    }

    public MonetaryAmountFactory<T> setCurrency(String currencyCode) {
        this.currency = MonetaryCurrencies.getCurrency((String)currencyCode);
        return this;
    }

    public MonetaryAmountFactory<T> setNumber(double number) {
        this.number = new BigDecimal(String.valueOf(number));
        return this;
    }

    public MonetaryAmountFactory<T> setNumber(long number) {
        this.number = BigDecimal.valueOf(number);
        return this;
    }

    public MonetaryAmountFactory<T> setContext(MonetaryContext monetaryContext) {
        Objects.requireNonNull(monetaryContext);
        this.monetaryContext = monetaryContext;
        return this;
    }

    public MonetaryContext getDefaultMonetaryContext() {
        return this.DEFAULT_MONETARY_CONTEXT;
    }

    public MonetaryContext getMaximalMonetaryContext() {
        return this.MAX_MONETARY_CONTEXT;
    }

    public MonetaryAmountFactory<T> setAmount(MonetaryAmount amt) {
        this.currency = amt.getCurrency();
        this.number = amt.getNumber().numberValue(BigDecimal.class);
        this.monetaryContext = new MonetaryContext.Builder(amt.getMonetaryContext()).setAmountType(this.DEFAULT_MONETARY_CONTEXT.getAmountType()).create();
        return this;
    }

    protected static BigDecimal getBigDecimal(Number num) {
        if (BigDecimal.class.equals(num.getClass())) {
            return (BigDecimal)num;
        }
        if (Long.class.equals(num.getClass()) || Integer.class.equals(num.getClass()) || Short.class.equals(num.getClass()) || Byte.class.equals(num.getClass()) || AtomicLong.class.equals(num.getClass())) {
            return BigDecimal.valueOf(num.longValue());
        }
        if (Float.class.equals(num.getClass()) || Double.class.equals(num.getClass())) {
            return new BigDecimal(num.toString());
        }
        if (num instanceof BigDecimal) {
            return (BigDecimal)num;
        }
        if (num instanceof BigInteger) {
            return new BigDecimal((BigInteger)num);
        }
        try {
            return new BigDecimal(num.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return BigDecimal.valueOf(num.doubleValue());
        }
    }
}

