/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.math.BigDecimal;
import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.convert.ConversionContext;
import javax.money.convert.CurrencyConversion;
import javax.money.convert.CurrencyConversionException;
import javax.money.convert.ExchangeRate;

public abstract class AbstractCurrencyConversion
implements CurrencyConversion {
    private CurrencyUnit termCurrency;
    private ConversionContext conversionContext;

    public AbstractCurrencyConversion(CurrencyUnit termCurrency, ConversionContext conversionContext) {
        Objects.requireNonNull(termCurrency);
        Objects.requireNonNull(conversionContext);
        this.termCurrency = termCurrency;
        this.conversionContext = conversionContext;
    }

    public CurrencyUnit getTermCurrency() {
        return this.termCurrency;
    }

    public ConversionContext getConversionContext() {
        return this.conversionContext;
    }

    public abstract ExchangeRate getExchangeRate(MonetaryAmount var1);

    public abstract CurrencyConversion with(ConversionContext var1);

    public <T extends MonetaryAmount> T apply(T amount) {
        ExchangeRate rate = this.getExchangeRate(amount);
        if (rate == null || !amount.getCurrency().equals(rate.getBase())) {
            throw new CurrencyConversionException(amount.getCurrency(), rate == null ? null : rate.getTerm(), null);
        }
        return (T)amount.getFactory().setCurrency(rate.getTerm()).setNumber(amount.multiply((Number)rate.getFactor()).getNumber().numberValue(BigDecimal.class)).create();
    }

    public String toString() {
        return this.getClass().getName() + " [MonetaryAmount -> MonetaryAmount" + "]";
    }
}

