/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryContext;
import javax.money.MonetaryException;
import javax.money.NumberValue;

public abstract class AbstractMoney
implements MonetaryAmount,
Serializable {
    private static final long serialVersionUID = 1L;
    protected CurrencyUnit currency;
    protected MonetaryContext monetaryContext;

    protected AbstractMoney() {
    }

    protected AbstractMoney(CurrencyUnit currency) {
        this(currency, null);
    }

    protected AbstractMoney(CurrencyUnit currency, MonetaryContext monetaryContext) {
        Objects.requireNonNull(currency, "Currency is required.");
        this.currency = currency;
        this.monetaryContext = monetaryContext != null ? monetaryContext : this.getDefaultMonetaryContext();
        Objects.requireNonNull(this.monetaryContext);
    }

    protected abstract MonetaryContext getDefaultMonetaryContext();

    public CurrencyUnit getCurrency() {
        return this.currency;
    }

    public MonetaryContext getMonetaryContext() {
        return this.monetaryContext;
    }

    protected static BigDecimal getBigDecimal(long num) {
        return BigDecimal.valueOf(num);
    }

    protected static BigDecimal getBigDecimal(double num) {
        return new BigDecimal(String.valueOf(num));
    }

    protected static BigDecimal getBigDecimal(Number num) {
        AbstractMoney.checkNumberParameter(num);
        if (num instanceof NumberValue) {
            return (BigDecimal)((NumberValue)num).numberValue(BigDecimal.class);
        }
        if (BigDecimal.class.equals(num.getClass())) {
            return (BigDecimal)num;
        }
        if (Long.class.equals(num.getClass()) || Integer.class.equals(num.getClass()) || Short.class.equals(num.getClass()) || Byte.class.equals(num.getClass()) || AtomicLong.class.equals(num.getClass())) {
            return BigDecimal.valueOf(num.longValue());
        }
        if (Float.class.equals(num.getClass()) || Double.class.equals(num.getClass())) {
            return new BigDecimal(num.toString());
        }
        if (num instanceof BigDecimal) {
            return (BigDecimal)num;
        }
        if (num instanceof BigInteger) {
            return new BigDecimal((BigInteger)num);
        }
        try {
            return new BigDecimal(num.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return BigDecimal.valueOf(num.doubleValue());
        }
    }

    protected static BigDecimal getBigDecimal(Number num, MonetaryContext moneyContext) {
        BigDecimal bd = AbstractMoney.getBigDecimal(num);
        if (moneyContext != null) {
            return new BigDecimal(bd.toString(), AbstractMoney.getMathContext(moneyContext, RoundingMode.HALF_EVEN));
        }
        return bd;
    }

    protected static MathContext getMathContext(MonetaryContext monetaryContext, RoundingMode defaultMode) {
        MathContext ctx = (MathContext)monetaryContext.getAttribute(MathContext.class);
        if (ctx != null) {
            return ctx;
        }
        if (defaultMode != null) {
            return new MathContext(monetaryContext.getPrecision(), (RoundingMode)((Object)monetaryContext.getAttribute(RoundingMode.class, (Object)defaultMode)));
        }
        return new MathContext(monetaryContext.getPrecision(), (RoundingMode)((Object)monetaryContext.getAttribute(RoundingMode.class, (Object)RoundingMode.HALF_EVEN)));
    }

    protected void checkAmountParameter(MonetaryAmount amount) {
        Objects.requireNonNull(amount, "Amount must not be null.");
        CurrencyUnit amountCurrency = amount.getCurrency();
        if (!this.currency.getCurrencyCode().equals(amountCurrency.getCurrencyCode())) {
            throw new MonetaryException("Currency mismatch: " + this.currency + '/' + amountCurrency);
        }
    }

    protected static void checkNumberParameter(Number number) {
        Objects.requireNonNull(number, "Number is required.");
    }
}

