/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;
import java.util.logging.Logger;
import javax.money.CurrencyUnit;
import javax.money.MonetaryCurrencies;
import javax.money.NumberValue;
import javax.money.convert.ConversionContext;
import javax.money.convert.CurrencyConversion;
import javax.money.convert.CurrencyConversionException;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ExchangeRateProvider;
import javax.money.convert.ProviderContext;
import org.javamoney.moneta.spi.DefaultNumberValue;
import org.javamoney.moneta.spi.LazyBoundCurrencyConversion;

public abstract class AbstractRateProvider
implements ExchangeRateProvider {
    protected final Logger LOGGER = Logger.getLogger(this.getClass().getName());
    private ProviderContext providerContext;

    public AbstractRateProvider(ProviderContext providerContext) {
        Objects.requireNonNull(providerContext);
        this.providerContext = providerContext;
    }

    protected abstract ExchangeRate getExchangeRateInternal(CurrencyUnit var1, CurrencyUnit var2, ConversionContext var3);

    public ProviderContext getProviderContext() {
        return this.providerContext;
    }

    public boolean isAvailable(CurrencyUnit src, CurrencyUnit target) {
        return this.getExchangeRate(src, target) != null;
    }

    public ExchangeRate getExchangeRate(CurrencyUnit source, CurrencyUnit target) {
        return this.getExchangeRate(source, target, ConversionContext.of());
    }

    public ExchangeRate getReversed(ExchangeRate rate) {
        if (this.isAvailable(rate.getTerm(), rate.getBase(), rate.getConversionContext())) {
            return this.getExchangeRate(rate.getTerm(), rate.getBase(), rate.getConversionContext());
        }
        return null;
    }

    public CurrencyConversion getCurrencyConversion(CurrencyUnit termCurrency) {
        return new LazyBoundCurrencyConversion(termCurrency, this, ConversionContext.of());
    }

    public CurrencyConversion getCurrencyConversion(CurrencyUnit term, ConversionContext conversionContext) {
        return new LazyBoundCurrencyConversion(term, this, conversionContext);
    }

    public boolean isAvailable(String baseCode, String termCode) {
        return this.isAvailable(MonetaryCurrencies.getCurrency((String)baseCode), MonetaryCurrencies.getCurrency((String)termCode), ConversionContext.of());
    }

    public ExchangeRate getExchangeRate(String baseCode, String termCode) {
        return this.getExchangeRate(MonetaryCurrencies.getCurrency((String)baseCode), MonetaryCurrencies.getCurrency((String)termCode), ConversionContext.of());
    }

    public CurrencyConversion getCurrencyConversion(String termCode) {
        return this.getCurrencyConversion(MonetaryCurrencies.getCurrency((String)termCode));
    }

    public CurrencyConversion getCurrencyConversion(String termCode, ConversionContext conversionContext) {
        return this.getCurrencyConversion(MonetaryCurrencies.getCurrency((String)termCode), conversionContext);
    }

    public boolean isAvailable(String baseCode, String termCode, ConversionContext conversionContext) {
        return this.isAvailable(MonetaryCurrencies.getCurrency((String)baseCode), MonetaryCurrencies.getCurrency((String)termCode), conversionContext);
    }

    public ExchangeRate getExchangeRate(String baseCode, String termCode, ConversionContext conversionContext) {
        return this.getExchangeRate(MonetaryCurrencies.getCurrency((String)baseCode), MonetaryCurrencies.getCurrency((String)termCode), conversionContext);
    }

    public boolean isAvailable(CurrencyUnit base, CurrencyUnit term, ConversionContext conversionContext) {
        return this.getExchangeRateInternal(base, term, conversionContext) != null;
    }

    public ExchangeRate getExchangeRate(CurrencyUnit base, CurrencyUnit term, ConversionContext conversionContext) {
        ExchangeRate rate = this.getExchangeRateInternal(base, term, conversionContext);
        if (rate == null) {
            throw new CurrencyConversionException(base, term, conversionContext);
        }
        return rate;
    }

    protected static final NumberValue multiply(NumberValue multiplicand, NumberValue multiplier) {
        if (multiplicand == null) {
            throw new ArithmeticException("The multiplicand cannot be null");
        }
        if (multiplier == null) {
            throw new ArithmeticException("The multiplier cannot be null");
        }
        return new DefaultNumberValue(((BigDecimal)multiplicand.numberValue(BigDecimal.class)).multiply((BigDecimal)multiplier.numberValue(BigDecimal.class)));
    }

    protected static final NumberValue divide(NumberValue dividend, NumberValue divisor) {
        if (dividend == null) {
            throw new ArithmeticException("The dividend cannot be null");
        }
        if (divisor == null) {
            throw new ArithmeticException("The divisor cannot be null");
        }
        return new DefaultNumberValue(((BigDecimal)dividend.numberValue(BigDecimal.class)).divide((BigDecimal)divisor.numberValue(BigDecimal.class)));
    }

    protected static final NumberValue divide(NumberValue dividend, NumberValue divisor, MathContext context) {
        if (dividend == null) {
            throw new ArithmeticException("The dividend cannot be null");
        }
        if (divisor == null) {
            throw new ArithmeticException("The divisor cannot be null");
        }
        return new DefaultNumberValue(((BigDecimal)dividend.numberValue(BigDecimal.class)).divide((BigDecimal)divisor.numberValue(BigDecimal.class), context));
    }
}

