/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.util.ArrayList;
import java.util.List;
import javax.money.CurrencyUnit;
import javax.money.convert.ConversionContext;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ExchangeRateProvider;
import javax.money.convert.ProviderContext;
import org.javamoney.moneta.spi.AbstractRateProvider;

public class CompoundRateProvider
extends AbstractRateProvider {
    private final List<ExchangeRateProvider> providers = new ArrayList<ExchangeRateProvider>();

    public CompoundRateProvider(Iterable<ExchangeRateProvider> providers) {
        super(CompoundRateProvider.createContext(providers));
        for (ExchangeRateProvider exchangeRateProvider : providers) {
            this.addProvider(exchangeRateProvider);
        }
    }

    private static ProviderContext createContext(Iterable<ExchangeRateProvider> providers) {
        StringBuilder providerName = new StringBuilder("Compound: ");
        for (ExchangeRateProvider exchangeRateProvider : providers) {
            providerName.append(exchangeRateProvider.getProviderContext().getProviderName());
            providerName.append(',');
        }
        providerName.setLength(providerName.length() - 1);
        return new ProviderContext.Builder(providerName.toString()).create();
    }

    private void addProvider(ExchangeRateProvider prov) {
        if (prov == null) {
            throw new IllegalArgumentException("ConversionProvider required.");
        }
        this.providers.add(prov);
    }

    @Override
    protected ExchangeRate getExchangeRateInternal(CurrencyUnit base, CurrencyUnit term, ConversionContext context) {
        for (ExchangeRateProvider prov : this.providers) {
            ExchangeRate rate;
            if (!prov.isAvailable(base, term, context) || (rate = prov.getExchangeRate(base, term, context)) == null) continue;
            return rate;
        }
        return null;
    }
}

