/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.money.NumberValue;

public class DefaultNumberValue
extends NumberValue {
    private static final long serialVersionUID = 1L;
    private final Number number;
    public static final NumberValue ONE = new DefaultNumberValue(BigDecimal.ONE);

    public DefaultNumberValue(Number number) {
        Objects.requireNonNull(number, "Number required");
        this.number = number;
    }

    public static NumberValue of(Number number) {
        return new DefaultNumberValue(number);
    }

    public Class<?> getNumberType() {
        return this.number.getClass();
    }

    public int getPrecision() {
        return this.numberValue(BigDecimal.class).precision();
    }

    public int getScale() {
        return this.numberValue(BigDecimal.class).scale();
    }

    public int intValue() {
        return this.number.intValue();
    }

    public int intValueExact() {
        return DefaultNumberValue.getBigDecimal(this.number).intValueExact();
    }

    public long longValue() {
        return this.number.longValue();
    }

    public long longValueExact() {
        return DefaultNumberValue.getBigDecimal(this.number).longValueExact();
    }

    public float floatValue() {
        return this.number.floatValue();
    }

    public double doubleValue() {
        return this.number.doubleValue();
    }

    public double doubleValueExact() {
        double d = this.number.doubleValue();
        if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY) {
            throw new ArithmeticException("Unable to convert to double: " + this.number);
        }
        return d;
    }

    public <T extends Number> T numberValue(Class<T> numberType) {
        if (BigDecimal.class == numberType) {
            return (T)DefaultNumberValue.getBigDecimal(this.number);
        }
        if (BigInteger.class == numberType) {
            return (T)DefaultNumberValue.getBigDecimal(this.number).toBigInteger();
        }
        if (Double.class == numberType) {
            return (T)Double.valueOf(this.number.doubleValue());
        }
        if (Float.class == numberType) {
            return (T)Float.valueOf(this.number.floatValue());
        }
        if (Long.class == numberType) {
            return (T)Long.valueOf(this.number.longValue());
        }
        if (Integer.class == numberType) {
            return (T)Integer.valueOf(this.number.intValue());
        }
        if (Short.class == numberType) {
            return (T)Short.valueOf(this.number.shortValue());
        }
        if (Byte.class == numberType) {
            return (T)Byte.valueOf(this.number.byteValue());
        }
        throw new IllegalArgumentException("Unsupported numeric type: " + numberType);
    }

    public <T extends Number> T numberValueExact(Class<T> numberType) {
        if (BigDecimal.class == numberType) {
            return (T)DefaultNumberValue.getBigDecimal(this.number);
        }
        if (BigInteger.class == numberType) {
            return (T)DefaultNumberValue.getBigDecimal(this.number).toBigIntegerExact();
        }
        if (Double.class == numberType) {
            double d = this.number.doubleValue();
            if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY) {
                throw new ArithmeticException("Value not exact mappable to double: " + this.number);
            }
            return (T)Double.valueOf(d);
        }
        if (Float.class == numberType) {
            float f = this.number.floatValue();
            if (f == Float.NEGATIVE_INFINITY || f == Float.POSITIVE_INFINITY) {
                throw new ArithmeticException("Value not exact mappable to float: " + this.number);
            }
            return (T)Float.valueOf(f);
        }
        if (Long.class == numberType) {
            return (T)Long.valueOf(DefaultNumberValue.getBigDecimal(this.number).longValueExact());
        }
        if (Integer.class == numberType) {
            return (T)Integer.valueOf(DefaultNumberValue.getBigDecimal(this.number).intValueExact());
        }
        if (Short.class == numberType) {
            return (T)Short.valueOf(DefaultNumberValue.getBigDecimal(this.number).shortValueExact());
        }
        if (Byte.class == numberType) {
            return (T)Short.valueOf(DefaultNumberValue.getBigDecimal(this.number).byteValueExact());
        }
        throw new IllegalArgumentException("Unsupported numeric type: " + numberType);
    }

    public String toString() {
        return String.valueOf(this.number);
    }

    protected static BigDecimal getBigDecimal(Number num) {
        if (BigDecimal.class.equals(num.getClass())) {
            return (BigDecimal)num;
        }
        if (Long.class.equals(num.getClass()) || Integer.class.equals(num.getClass()) || Short.class.equals(num.getClass()) || Byte.class.equals(num.getClass()) || AtomicLong.class.equals(num.getClass())) {
            return BigDecimal.valueOf(num.longValue());
        }
        if (Float.class.equals(num.getClass()) || Double.class.equals(num.getClass())) {
            return new BigDecimal(num.toString());
        }
        if (num instanceof BigDecimal) {
            return (BigDecimal)num;
        }
        if (num instanceof BigInteger) {
            return new BigDecimal((BigInteger)num);
        }
        try {
            return new BigDecimal(num.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return BigDecimal.valueOf(num.doubleValue());
        }
    }
}

