/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryQuery;

final class MinorUnits
implements MonetaryQuery<Long> {
    MinorUnits() {
    }

    public Long queryFrom(MonetaryAmount amount) {
        Objects.requireNonNull(amount, "Amount required.");
        BigDecimal number = (BigDecimal)amount.getNumber().numberValue(BigDecimal.class);
        CurrencyUnit cur = amount.getCurrency();
        int scale = cur.getDefaultFractionDigits();
        if (scale < 0) {
            scale = 0;
        }
        number = number.setScale(scale, RoundingMode.DOWN);
        return number.movePointRight(number.scale()).longValueExact();
    }
}

