/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal;

import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryException;
import javax.money.spi.Bootstrap;
import javax.money.spi.MonetaryAmountFactoryProviderSpi;
import javax.money.spi.MonetaryAmountsSingletonSpi;
import org.javamoney.moneta.spi.ServicePriority;

public class DefaultMonetaryAmountsSingletonSpi
implements MonetaryAmountsSingletonSpi {
    private Map<Class<? extends MonetaryAmount>, MonetaryAmountFactoryProviderSpi<?>> factories = new ConcurrentHashMap();
    private Class<? extends MonetaryAmount> configuredDefaultAmountType = this.loadDefaultAmountType();

    public DefaultMonetaryAmountsSingletonSpi() {
        for (MonetaryAmountFactoryProviderSpi f : Bootstrap.getServices(MonetaryAmountFactoryProviderSpi.class)) {
            MonetaryAmountFactoryProviderSpi existing = this.factories.put(f.getAmountType(), f);
            if (!Objects.nonNull(existing)) continue;
            int compare = DefaultMonetaryAmountsSingletonSpi.comparePriority(existing, f);
            if (compare < 0) {
                Logger.getLogger(this.getClass().getName()).warning("MonetaryAmountFactoryProviderSpi with lower prio ignored: " + f);
                this.factories.put(f.getAmountType(), existing);
                continue;
            }
            if (compare != 0) continue;
            throw new IllegalStateException("Ambigous MonetaryAmountFactoryProviderSpi found for " + f.getAmountType() + ": " + f.getClass().getName() + '/' + existing.getClass().getName());
        }
    }

    private static int getServicePriority(Object service) {
        if (Objects.isNull(service)) {
            return Integer.MIN_VALUE;
        }
        ServicePriority prio = service.getClass().getAnnotation(ServicePriority.class);
        if (Objects.nonNull(prio)) {
            return prio.value();
        }
        return 0;
    }

    public static <T> int comparePriority(T service1, T service2) {
        int servicePriority2;
        int servicePriority1 = DefaultMonetaryAmountsSingletonSpi.getServicePriority(service1);
        return servicePriority1 == (servicePriority2 = DefaultMonetaryAmountsSingletonSpi.getServicePriority(service2)) ? 0 : (servicePriority1 < servicePriority2 ? 1 : -1);
    }

    private Class<? extends MonetaryAmount> loadDefaultAmountType() {
        return null;
    }

    public <T extends MonetaryAmount> MonetaryAmountFactory<T> getAmountFactory(Class<T> amountType) {
        MonetaryAmountFactoryProviderSpi f = (MonetaryAmountFactoryProviderSpi)MonetaryAmountFactoryProviderSpi.class.cast(this.factories.get(amountType));
        if (Objects.nonNull(f)) {
            return f.createMonetaryAmountFactory();
        }
        throw new MonetaryException("No matching MonetaryAmountFactory found, type=" + amountType.getName());
    }

    public Set<Class<? extends MonetaryAmount>> getAmountTypes() {
        return this.factories.keySet();
    }

    public Class<? extends MonetaryAmount> getDefaultAmountType() {
        if (Objects.isNull(this.configuredDefaultAmountType)) {
            for (MonetaryAmountFactoryProviderSpi f : Bootstrap.getServices(MonetaryAmountFactoryProviderSpi.class)) {
                if (f.getQueryInclusionPolicy() != MonetaryAmountFactoryProviderSpi.QueryInclusionPolicy.ALWAYS) continue;
                this.configuredDefaultAmountType = f.getAmountType();
                break;
            }
        }
        return Optional.ofNullable(this.configuredDefaultAmountType).orElseThrow(() -> new MonetaryException("No MonetaryAmountFactoryProviderSpi registered."));
    }

    public static final class ProviderComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object p1, Object p2) {
            return DefaultMonetaryAmountsSingletonSpi.comparePriority(p1, p2);
        }
    }
}

