/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.loader.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javamoney.moneta.loader.internal.ResourceCache;
import org.javamoney.moneta.spi.LoaderService;

public class LoadableResource {
    private static final Logger LOG = Logger.getLogger(LoadableResource.class.getName());
    private final Object LOCK = new Object();
    private String resourceId;
    private List<URI> remoteResources = new ArrayList<URI>();
    private URI fallbackLocation;
    private ResourceCache cache;
    private AtomicInteger loadCount = new AtomicInteger();
    private AtomicInteger accessCount = new AtomicInteger();
    private volatile SoftReference<byte[]> data;
    private long lastLoaded;
    private long cacheTTLMillis = 86400000L;
    private LoaderService.UpdatePolicy updatePolicy;
    private Map<String, String> properties;

    public LoadableResource(String resourceId, ResourceCache cache, LoaderService.UpdatePolicy updatePolicy, Map<String, String> properties, URI fallbackLocation, URI ... locations) {
        Objects.requireNonNull(resourceId, "resourceId required");
        Objects.requireNonNull(properties, "properties required");
        Objects.requireNonNull(updatePolicy, "updatePolicy required");
        String val = properties.get("cacheTTLMillis");
        if (val != null) {
            this.cacheTTLMillis = Long.parseLong(val);
        }
        this.cache = cache;
        this.resourceId = resourceId;
        this.updatePolicy = updatePolicy;
        this.properties = properties;
        this.fallbackLocation = fallbackLocation;
        this.remoteResources.addAll(Arrays.asList(locations));
    }

    public LoaderService.UpdatePolicy getUpdatePolicy() {
        return this.updatePolicy;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean load() {
        if (this.lastLoaded + this.cacheTTLMillis <= System.currentTimeMillis()) {
            this.clearCache();
        }
        if (!this.readCache() && !this.loadRemote()) {
            return this.loadFallback();
        }
        return true;
    }

    public final String getResourceId() {
        return this.resourceId;
    }

    public final List<URI> getRemoteResources() {
        return Collections.unmodifiableList(this.remoteResources);
    }

    public final URI getFallbackResource() {
        return this.fallbackLocation;
    }

    public final int getLoadCount() {
        return this.loadCount.get();
    }

    public final int getAccessCount() {
        return this.accessCount.get();
    }

    public InputStream getDataStream() {
        return new WrappedInputStream(new ByteArrayInputStream(this.getData()));
    }

    public final long getLastLoaded() {
        return this.lastLoaded;
    }

    public boolean loadRemote() {
        for (URI itemToLoad : this.remoteResources) {
            try {
                return this.load(itemToLoad, false);
            }
            catch (Exception e) {
                LOG.log(Level.INFO, "Failed to load resource: " + itemToLoad, e);
            }
        }
        return false;
    }

    public boolean loadFallback() {
        try {
            if (this.fallbackLocation == null) {
                Logger.getLogger(this.getClass().getName()).warning("No fallback resource for " + this + ", loadFallback not supported.");
                return false;
            }
            this.load(this.fallbackLocation, true);
            this.clearCache();
            return true;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to load fallback resource: " + this.fallbackLocation, e);
            return false;
        }
    }

    protected void clearCache() {
        if (this.cache != null) {
            this.cache.clear(this.resourceId);
        }
    }

    protected boolean readCache() {
        byte[] data;
        if (this.cache != null && this.cache.isCached(this.resourceId) && (data = this.cache.read(this.resourceId)) != null) {
            this.setData(data);
            return true;
        }
        return false;
    }

    protected void writeCache() {
        if (this.cache != null) {
            byte[] data;
            byte[] byArray = data = this.data == null ? null : this.data.get();
            if (data == null) {
                return;
            }
            this.cache.write(this.resourceId, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean load(URI itemToLoad, boolean fallbackLoad) {
        InputStream is = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            URLConnection conn = itemToLoad.toURL().openConnection();
            byte[] data = new byte[4096];
            is = conn.getInputStream();
            int read = is.read(data);
            while (read > 0) {
                bos.write(data, 0, read);
                read = is.read(data);
            }
            this.setData(bos.toByteArray());
            if (!fallbackLoad) {
                this.writeCache();
            }
            if (!fallbackLoad) {
                this.lastLoaded = System.currentTimeMillis();
                this.loadCount.incrementAndGet();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Failed to load resource input for " + this.resourceId + " from " + itemToLoad, e);
        }
        finally {
            if (Objects.nonNull(is)) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, "Error closing resource input for " + this.resourceId, e);
                }
            }
            if (Objects.nonNull(bos)) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    LOG.log(Level.INFO, "Error closing resource input for " + this.resourceId, e);
                }
            }
        }
        return false;
    }

    public final byte[] getData() {
        return this.getData(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getData(boolean loadIfNeeded) {
        byte[] result;
        byte[] byArray = result = this.data == null ? null : this.data.get();
        if (result == null && loadIfNeeded) {
            byte[] currentData;
            this.accessCount.incrementAndGet();
            byte[] byArray2 = currentData = this.data == null ? null : this.data.get();
            if (Objects.isNull(currentData)) {
                Object object = this.LOCK;
                synchronized (object) {
                    byte[] byArray3 = currentData = this.data == null ? null : this.data.get();
                    if (Objects.isNull(currentData) && !this.loadRemote()) {
                        this.loadFallback();
                    }
                }
            }
            byte[] byArray4 = currentData = this.data == null ? null : this.data.get();
            if (Objects.isNull(currentData)) {
                throw new IllegalStateException("Failed to load remote as well as fallback resources for " + this);
            }
            return (byte[])currentData.clone();
        }
        return result;
    }

    protected final void setData(byte[] bytes) {
        this.data = new SoftReference<byte[]>(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload() {
        Object object = this.LOCK;
        synchronized (object) {
            int count = this.accessCount.decrementAndGet();
            if (count == 0) {
                this.data = null;
            }
        }
    }

    public boolean resetToFallback() throws IOException {
        if (this.loadFallback()) {
            this.loadCount.set(0);
            return true;
        }
        return false;
    }

    public String toString() {
        return "LoadableResource [resourceId=" + this.resourceId + ", fallbackLocation=" + this.fallbackLocation + ", remoteResources=" + this.remoteResources + ", loadCount=" + this.loadCount + ", accessCount=" + this.accessCount + ", lastLoaded=" + this.lastLoaded + "]";
    }

    private final class WrappedInputStream
    extends InputStream {
        private InputStream wrapped;

        public WrappedInputStream(InputStream wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public int read() throws IOException {
            return this.wrapped.read();
        }

        @Override
        public void close() throws IOException {
            try {
                this.wrapped.close();
                super.close();
            }
            finally {
                LoadableResource.this.unload();
            }
        }
    }
}

