/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryCurrencies;
import javax.money.format.AmountFormatContext;
import javax.money.format.MonetaryAmountFormat;
import javax.money.format.MonetaryParseException;
import org.javamoney.moneta.FastMoney;
import org.javamoney.moneta.Money;
import org.javamoney.moneta.RoundedMoney;

class ToStringMonetaryAmountFormat
implements MonetaryAmountFormat {
    private ToStringMonetaryAmountFormatStyle style;

    private ToStringMonetaryAmountFormat(ToStringMonetaryAmountFormatStyle style) {
        this.style = Objects.requireNonNull(style);
    }

    public static ToStringMonetaryAmountFormat of(ToStringMonetaryAmountFormatStyle style) {
        return new ToStringMonetaryAmountFormat(style);
    }

    public String queryFrom(MonetaryAmount amount) {
        if (Objects.isNull(amount)) {
            return null;
        }
        return amount.toString();
    }

    public AmountFormatContext getAmountFormatContext() {
        throw new UnsupportedOperationException("ToStringMonetaryAmountFormat does not the method suport getAmountFormatContext()");
    }

    public void print(Appendable appendable, MonetaryAmount amount) throws IOException {
        appendable.append(Optional.ofNullable(amount).map(Object::toString).orElse("null"));
    }

    public MonetaryAmount parse(CharSequence text) throws MonetaryParseException {
        ParserMonetaryAmount amount = this.parserMonetaryAmount(text);
        return this.style.to(amount);
    }

    private ParserMonetaryAmount parserMonetaryAmount(CharSequence text) {
        String[] array = Objects.requireNonNull(text).toString().split(" ");
        CurrencyUnit currencyUnit = MonetaryCurrencies.getCurrency((String)array[0], (String[])new String[0]);
        BigDecimal number = new BigDecimal(array[1]);
        return new ParserMonetaryAmount(currencyUnit, number);
    }

    static enum ToStringMonetaryAmountFormatStyle {
        MONEY{

            @Override
            MonetaryAmount to(ParserMonetaryAmount amount) {
                return Money.of(amount.number, amount.currencyUnit);
            }
        }
        ,
        FAST_MONEY{

            @Override
            MonetaryAmount to(ParserMonetaryAmount amount) {
                return FastMoney.of((Number)amount.number, amount.currencyUnit);
            }
        }
        ,
        ROUNDED_MONEY{

            @Override
            MonetaryAmount to(ParserMonetaryAmount amount) {
                return RoundedMoney.of(amount.number, amount.currencyUnit);
            }
        };


        abstract MonetaryAmount to(ParserMonetaryAmount var1);
    }

    private class ParserMonetaryAmount {
        private CurrencyUnit currencyUnit;
        private BigDecimal number;

        public ParserMonetaryAmount(CurrencyUnit currencyUnit, BigDecimal number) {
            this.currencyUnit = currencyUnit;
            this.number = number;
        }
    }
}

