/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.convert.internal;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.MathContext;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.money.CurrencyUnit;
import javax.money.MonetaryCurrencies;
import javax.money.convert.ConversionContextBuilder;
import javax.money.convert.ConversionQuery;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ProviderContext;
import javax.money.convert.ProviderContextBuilder;
import javax.money.convert.RateType;
import javax.money.spi.Bootstrap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.javamoney.moneta.ExchangeRateBuilder;
import org.javamoney.moneta.spi.AbstractRateProvider;
import org.javamoney.moneta.spi.DefaultNumberValue;
import org.javamoney.moneta.spi.LoaderService;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ECBCurrentRateProvider
extends AbstractRateProvider
implements LoaderService.LoaderListener {
    private static final String BASE_CURRENCY_CODE = "EUR";
    public static final CurrencyUnit BASE_CURRENCY = MonetaryCurrencies.getCurrency((String)"EUR", (String[])new String[0]);
    private static final String DATA_ID = ECBCurrentRateProvider.class.getSimpleName();
    private Map<String, ExchangeRate> currentRates = new ConcurrentHashMap<String, ExchangeRate>();
    private SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
    private static final ProviderContext CONTEXT = ((ProviderContextBuilder)((ProviderContextBuilder)ProviderContextBuilder.of((String)"ECB", (RateType)RateType.DEFERRED, (RateType[])new RateType[0]).set((Object)"providerDescription", "European Central Bank")).set((Object)"days", 1)).build();

    public ECBCurrentRateProvider() throws MalformedURLException {
        super(CONTEXT);
        this.saxParserFactory.setNamespaceAware(false);
        this.saxParserFactory.setValidating(false);
        LoaderService loader = (LoaderService)Bootstrap.getService(LoaderService.class);
        loader.addLoaderListener(this, DATA_ID);
        try {
            loader.loadData(DATA_ID);
        }
        catch (IOException e) {
            this.LOGGER.log(Level.SEVERE, "Error loading ECB data.", e);
        }
    }

    @Override
    public void newDataLoaded(String data, InputStream is) {
        try {
            SAXParser parser = this.saxParserFactory.newSAXParser();
            parser.parse(is, (DefaultHandler)new RateReadingHandler());
            this.LOGGER.info("Loaded current " + DATA_ID + " exchange rates.");
        }
        catch (Exception e) {
            this.LOGGER.log(Level.SEVERE, "Error reading resource for ECB currencies: ", e);
        }
    }

    public boolean isAvailable(ConversionQuery conversionQuery) {
        String baseCode = conversionQuery.getBaseCurrency().getCurrencyCode();
        String termCode = conversionQuery.getCurrency().getCurrencyCode();
        if (!BASE_CURRENCY_CODE.equals(baseCode) && !this.currentRates.containsKey(baseCode)) {
            return false;
        }
        if (!BASE_CURRENCY_CODE.equals(termCode) && !this.currentRates.containsKey(termCode)) {
            return false;
        }
        return Objects.isNull(conversionQuery.getTimestampMillis());
    }

    @Override
    public ExchangeRate getExchangeRate(ConversionQuery conversionQuery) {
        if (!this.isAvailable(conversionQuery)) {
            return null;
        }
        return this.getExchangeRateInternal(conversionQuery.getBaseCurrency(), conversionQuery.getCurrency());
    }

    private ExchangeRate getExchangeRateInternal(CurrencyUnit base, CurrencyUnit term) {
        ExchangeRateBuilder builder = new ExchangeRateBuilder(ConversionContextBuilder.create((ProviderContext)CONTEXT, (RateType)RateType.DEFERRED).build());
        builder.setBase(base);
        builder.setTerm(term);
        if (this.currentRates.isEmpty()) {
            return null;
        }
        ExchangeRate sourceRate = this.currentRates.get(base.getCurrencyCode());
        ExchangeRate target = this.currentRates.get(term.getCurrencyCode());
        if (base.getCurrencyCode().equals(term.getCurrencyCode())) {
            return null;
        }
        if (BASE_CURRENCY_CODE.equals(term.getCurrencyCode())) {
            if (Objects.isNull(sourceRate)) {
                return null;
            }
            return this.getReversed(sourceRate);
        }
        if (BASE_CURRENCY_CODE.equals(base.getCurrencyCode())) {
            return target;
        }
        ExchangeRate rate1 = this.getExchangeRateInternal(base, MonetaryCurrencies.getCurrency((String)BASE_CURRENCY_CODE, (String[])new String[0]));
        ExchangeRate rate2 = this.getExchangeRateInternal(MonetaryCurrencies.getCurrency((String)BASE_CURRENCY_CODE, (String[])new String[0]), term);
        if (Objects.nonNull(rate1) && Objects.nonNull(rate2)) {
            builder.setFactor(ECBCurrentRateProvider.multiply(rate1.getFactor(), rate2.getFactor()));
            builder.setRateChain(rate1, rate2);
            return builder.build();
        }
        return null;
    }

    public ExchangeRate getReversed(ExchangeRate rate) {
        if (rate.getConversionContext().getProvider().equals(CONTEXT.getProvider())) {
            return new ExchangeRateBuilder(rate.getConversionContext()).setTerm(rate.getBaseCurrency()).setBase(rate.getCurrency()).setFactor(new DefaultNumberValue(BigDecimal.ONE.divide((BigDecimal)rate.getFactor().numberValue(BigDecimal.class), MathContext.DECIMAL64))).build();
        }
        return null;
    }

    void addRate(CurrencyUnit term, Long timestamp, Number factor) {
        ExchangeRateBuilder builder = timestamp == null ? new ExchangeRateBuilder(ConversionContextBuilder.create((ProviderContext)CONTEXT, (RateType)RateType.DEFERRED).build()) : new ExchangeRateBuilder(((ConversionContextBuilder)ConversionContextBuilder.create((ProviderContext)CONTEXT, (RateType)RateType.DEFERRED).setTimestampMillis(timestamp.longValue())).build());
        builder.setBase(BASE_CURRENCY);
        builder.setTerm(term);
        builder.setFactor(new DefaultNumberValue(factor));
        this.currentRates.put(term.getCurrencyCode(), builder.build());
    }

    private class RateReadingHandler
    extends DefaultHandler {
        private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        private Long timestamp;

        public RateReadingHandler() {
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            try {
                if ("Cube".equals(qName)) {
                    if (Objects.nonNull(attributes.getValue("time"))) {
                        Date date = this.dateFormat.parse(attributes.getValue("time"));
                        this.timestamp = date.getTime();
                    } else if (Objects.nonNull(attributes.getValue("currency"))) {
                        CurrencyUnit tgtCurrency = MonetaryCurrencies.getCurrency((String)attributes.getValue("currency"), (String[])new String[0]);
                        ECBCurrentRateProvider.this.addRate(tgtCurrency, this.timestamp, BigDecimal.valueOf(Double.parseDouble(attributes.getValue("rate"))));
                    }
                }
                super.startElement(uri, localName, qName, attributes);
            }
            catch (ParseException e) {
                throw new SAXException("Failed to read.", e);
            }
        }
    }
}

