/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.loader.internal;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javamoney.moneta.spi.LoaderService;
import org.javamoney.moneta.spi.MonetaryConfig;

class LoaderConfigurator {
    private static final String LOAD = "load.";
    private static final String TYPE = "type";
    private static final Logger LOG = Logger.getLogger(LoaderConfigurator.class.getName());
    private LoaderService loaderService;

    public LoaderConfigurator(LoaderService loaderService) {
        Objects.requireNonNull(loaderService);
        this.loaderService = loaderService;
    }

    public void load() {
        Map<String, String> config = MonetaryConfig.getConfig();
        HashSet<String> loads = new HashSet<String>();
        for (String key : config.keySet()) {
            if (!key.startsWith(LOAD) || !key.endsWith(".type")) continue;
            String res = key.substring(LOAD.length());
            res = res.substring(0, res.length() - ".type".length());
            loads.add(res);
        }
        for (String l : loads) {
            try {
                this.initResource(l, config);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to initialize/register resource: " + l, e);
            }
        }
    }

    private void initResource(String name, Map<String, String> allProps) throws MalformedURLException {
        String[] resources;
        Map<String, String> props = this.mapProperties(allProps, name);
        LoaderService.UpdatePolicy updatePolicy = LoaderService.UpdatePolicy.valueOf(props.get(TYPE));
        String fallbackRes = props.get("resource");
        if (Objects.isNull(fallbackRes)) {
            throw new IllegalArgumentException(LOAD + name + ".resource (classpath resource) required.");
        }
        String resourcesString = props.get("urls");
        if (Objects.isNull(resourcesString)) {
            LOG.info("No update URLs configured for: " + name);
            resources = new String[]{};
        } else {
            resources = resourcesString.split(",");
        }
        URI[] urls = this.createURIs(resources);
        this.loaderService.registerData(name, updatePolicy, props, null, this.getClassLoaderLocation(fallbackRes), urls);
    }

    private URI[] createURIs(String[] resources) throws MalformedURLException {
        ArrayList<URI> urls = new ArrayList<URI>(resources.length);
        for (String res : resources) {
            if (res.trim().isEmpty()) continue;
            try {
                urls.add(new URL(res.trim()).toURI());
            }
            catch (URISyntaxException e) {
                LOG.log(Level.WARNING, "Failed to load resoiurce as URI: " + res.trim(), e);
            }
        }
        return urls.toArray(new URI[urls.size()]);
    }

    private URI getClassLoaderLocation(String res) {
        URL url = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (Objects.nonNull(cl)) {
            url = cl.getResource(res);
        }
        if (Objects.isNull(url)) {
            url = this.getClass().getResource(res);
        }
        if (Objects.isNull(url)) {
            throw new IllegalArgumentException("Resource not found: " + res);
        }
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            LOG.log(Level.WARNING, "Failed to load resoiurce as URI: " + res.trim(), e);
            return null;
        }
    }

    private Map<String, String> mapProperties(Map<String, String> allProps, String name) {
        HashMap<String, String> props = new HashMap<String, String>();
        String start = LOAD + name;
        for (Map.Entry<String, String> entry : allProps.entrySet()) {
            if (!entry.getKey().startsWith(start)) continue;
            props.put(entry.getKey().substring(start.length() + 1), entry.getValue());
        }
        return props;
    }
}

