/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MonetaryConfig {
    private static final Logger LOG = Logger.getLogger(MonetaryConfig.class.getName());
    private static final MonetaryConfig INSTANCE = new MonetaryConfig();
    private Map<String, String> config = new HashMap<String, String>();
    private Map<String, Integer> priorities = new HashMap<String, Integer>();

    private MonetaryConfig() {
        try {
            Enumeration<URL> urls = this.getClass().getClassLoader().getResources("javamoney.properties");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                try {
                    Properties props = new Properties();
                    props.load(url.openStream());
                    this.updateConfig(props);
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Error loading javamoney.properties, ignoring " + url, e);
                }
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Error loading javamoney.properties.", e);
        }
    }

    private void updateConfig(Properties props) {
        for (Map.Entry<Object, Object> en : props.entrySet()) {
            int index;
            String key = en.getKey().toString();
            String value = en.getValue().toString();
            Integer existingPrio = this.priorities.get(key);
            int prio = 0;
            if (value.startsWith("{prio=") && (index = value.indexOf(125)) > 0) {
                String prioString = value.substring("{prio=".length(), index);
                value = value.substring(index + 1);
                prio = Integer.parseInt(prioString);
                this.priorities.put(key, prio);
            }
            if (Objects.isNull(existingPrio)) {
                this.config.put(key, value);
                continue;
            }
            if (existingPrio < prio) {
                this.config.put(key, value);
                continue;
            }
            if (existingPrio != prio) continue;
            throw new IllegalStateException("AmbiguousConfiguration detected for '" + key + "'.");
        }
    }

    public static Map<String, String> getConfig() {
        return Collections.unmodifiableMap(MonetaryConfig.INSTANCE.config);
    }
}

