/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.format.internal;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import javax.money.MonetaryAmount;
import javax.money.format.AmountFormatContext;
import javax.money.format.MonetaryParseException;
import org.javamoney.moneta.format.internal.FormatToken;
import org.javamoney.moneta.format.internal.ParseContext;
import org.javamoney.moneta.format.internal.StringGrouper;

final class AmountNumberToken
implements FormatToken {
    private AmountFormatContext amountFormatContext;
    private String partialNumberPattern;
    private DecimalFormat parseFormat;
    private DecimalFormat formatFormat;
    private StringGrouper numberGroup;

    public AmountNumberToken(AmountFormatContext amountFormatContext, String partialNumberPattern) {
        this.amountFormatContext = Optional.ofNullable(amountFormatContext).orElseThrow(() -> new IllegalArgumentException("amountFormatContext is required."));
        this.partialNumberPattern = partialNumberPattern;
        this.initDecimalFormats();
    }

    private void initDecimalFormats() {
        this.formatFormat = (DecimalFormat)DecimalFormat.getInstance((Locale)this.amountFormatContext.get(Locale.class));
        this.parseFormat = (DecimalFormat)DecimalFormat.getInstance((Locale)this.amountFormatContext.get(Locale.class));
        DecimalFormatSymbols syms = (DecimalFormatSymbols)this.amountFormatContext.get(DecimalFormatSymbols.class);
        if (Objects.nonNull(syms)) {
            this.formatFormat.setDecimalFormatSymbols(syms);
            this.parseFormat.setDecimalFormatSymbols(syms);
        }
        this.formatFormat.applyPattern(this.partialNumberPattern);
        this.parseFormat.applyPattern(this.partialNumberPattern.trim());
    }

    public AmountFormatContext getAmountFormatContext() {
        return this.amountFormatContext;
    }

    public String getNumberPattern() {
        return this.partialNumberPattern;
    }

    @Override
    public void print(Appendable appendable, MonetaryAmount amount) throws IOException {
        int digits = amount.getCurrency().getDefaultFractionDigits();
        this.formatFormat.setMinimumFractionDigits(digits);
        this.formatFormat.setMaximumFractionDigits(digits);
        if (this.amountFormatContext.get("groupingSizes", int[].class) == null || ((int[])this.amountFormatContext.get("groupingSizes", int[].class)).length == 0) {
            appendable.append(this.formatFormat.format(amount.getNumber().numberValue(BigDecimal.class)));
            return;
        }
        this.formatFormat.setGroupingUsed(false);
        String preformattedValue = this.formatFormat.format(amount.getNumber().numberValue(BigDecimal.class));
        String[] numberParts = this.splitNumberParts(this.formatFormat, preformattedValue);
        if (numberParts.length != 2) {
            appendable.append(preformattedValue);
        } else {
            if (Objects.isNull(this.numberGroup)) {
                int[] groupSizes;
                char[] groupChars = (char[])this.amountFormatContext.get("groupingSeparators", char[].class);
                if (groupChars == null || groupChars.length == 0) {
                    groupChars = new char[]{this.formatFormat.getDecimalFormatSymbols().getGroupingSeparator()};
                }
                if ((groupSizes = (int[])this.amountFormatContext.get("groupingSizes", int[].class)) == null) {
                    groupSizes = new int[]{};
                }
                this.numberGroup = new StringGrouper(groupChars, groupSizes);
            }
            preformattedValue = this.numberGroup.group(numberParts[0]) + this.formatFormat.getDecimalFormatSymbols().getDecimalSeparator() + numberParts[1];
            appendable.append(preformattedValue);
        }
    }

    private String[] splitNumberParts(DecimalFormat format, String preformattedValue) {
        int index = preformattedValue.indexOf(format.getDecimalFormatSymbols().getDecimalSeparator());
        if (index < 0) {
            return new String[]{preformattedValue};
        }
        return new String[]{preformattedValue.substring(0, index), preformattedValue.substring(index + 1)};
    }

    @Override
    public void parse(ParseContext context) throws MonetaryParseException {
        String token = context.lookupNextToken();
        if (Objects.nonNull(token) && !context.isComplete()) {
            this.parseToken(context, token);
            if (context.hasError()) {
                throw new MonetaryParseException(context.getErrorMessage(), context.getInput(), context.getIndex());
            }
        } else {
            context.setError();
            context.setErrorMessage("Number expected.");
        }
    }

    private void parseToken(ParseContext context, String token) {
        try {
            Number number = this.parseFormat.parse(token);
            if (Objects.nonNull(number)) {
                context.setParsedNumber(number);
                context.consume(token);
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).finest("Could not parse amount from: " + token);
            context.setError();
            context.setErrorMessage(e.getMessage());
        }
    }
}

