/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.loader.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.spi.Bootstrap;
import org.javamoney.moneta.loader.internal.DefaultResourceCache;
import org.javamoney.moneta.loader.internal.LoadableResource;
import org.javamoney.moneta.loader.internal.LoaderConfigurator;
import org.javamoney.moneta.loader.internal.ResourceCache;
import org.javamoney.moneta.spi.LoaderService;

public class DefaultLoaderService
implements LoaderService {
    private static final Logger LOG = Logger.getLogger(DefaultLoaderService.class.getName());
    private Map<String, LoadableResource> resources = new ConcurrentHashMap<String, LoadableResource>();
    private final Map<String, List<LoaderService.LoaderListener>> listenersMap = new ConcurrentHashMap<String, List<LoaderService.LoaderListener>>();
    private static final ResourceCache CACHE = DefaultLoaderService.loadResourceCache();
    private ExecutorService executors = Executors.newCachedThreadPool();
    private volatile Timer timer;

    public DefaultLoaderService() {
        this.initialize();
    }

    protected void initialize() {
        Timer oldTimer = this.timer;
        this.timer = new Timer();
        if (Objects.nonNull(oldTimer)) {
            oldTimer.cancel();
        }
        LoaderConfigurator configurator = new LoaderConfigurator(this);
        configurator.load();
    }

    private static ResourceCache loadResourceCache() {
        try {
            return (ResourceCache)Bootstrap.getService(ResourceCache.class, (Object)new DefaultResourceCache());
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error loading ResourceCache instance.", e);
            return new DefaultResourceCache();
        }
    }

    static ResourceCache getResourceCache() {
        return CACHE;
    }

    public void unload(String resourceId) {
        LoadableResource res = this.resources.get(resourceId);
        if (Objects.nonNull(res)) {
            res.unload();
        }
    }

    @Override
    public void registerData(String resourceId, LoaderService.UpdatePolicy updatePolicy, Map<String, String> properties, LoaderService.LoaderListener loaderListener, URI backupResource, URI ... resourceLocations) {
        if (this.resources.containsKey(resourceId)) {
            throw new IllegalArgumentException("Resource : " + resourceId + " already registered.");
        }
        LoadableResource res = new LoadableResource(resourceId, CACHE, updatePolicy, properties, backupResource, resourceLocations);
        this.resources.put(resourceId, res);
        if (loaderListener != null) {
            this.addLoaderListener(loaderListener, resourceId);
        }
        switch (updatePolicy) {
            case NEVER: {
                this.loadDataLocal(resourceId);
                break;
            }
            case ONSTARTUP: {
                this.loadDataAsync(resourceId);
                break;
            }
            case SCHEDULED: {
                this.addScheduledLoad(res);
                break;
            }
        }
    }

    @Override
    public void registerAndLoadData(String resourceId, LoaderService.UpdatePolicy updatePolicy, Map<String, String> properties, LoaderService.LoaderListener loaderListener, URI backupResource, URI ... resourceLocations) {
        if (this.resources.containsKey(resourceId)) {
            throw new IllegalArgumentException("Resource : " + resourceId + " already registered.");
        }
        LoadableResource res = new LoadableResource(resourceId, CACHE, updatePolicy, properties, backupResource, resourceLocations);
        this.resources.put(resourceId, res);
        if (loaderListener != null) {
            this.addLoaderListener(loaderListener, resourceId);
        }
        switch (updatePolicy) {
            case SCHEDULED: {
                this.addScheduledLoad(res);
                break;
            }
        }
        this.loadData(resourceId);
    }

    @Override
    public Map<String, String> getUpdateConfiguration(String resourceId) {
        LoadableResource load = this.resources.get(resourceId);
        if (Objects.nonNull(load)) {
            return load.getProperties();
        }
        return null;
    }

    @Override
    public boolean isResourceRegistered(String dataId) {
        return this.resources.containsKey(dataId);
    }

    @Override
    public Set<String> getResourceIds() {
        return this.resources.keySet();
    }

    @Override
    public InputStream getData(String resourceId) throws IOException {
        LoadableResource load = this.resources.get(resourceId);
        if (Objects.nonNull(load)) {
            load.getDataStream();
        }
        throw new IllegalArgumentException("No such resource: " + resourceId);
    }

    @Override
    public boolean loadData(String resourceId) {
        return this.loadDataSynch(resourceId);
    }

    @Override
    public Future<Boolean> loadDataAsync(String resourceId) {
        return this.executors.submit(() -> this.loadDataSynch(resourceId));
    }

    @Override
    public boolean loadDataLocal(String resourceId) {
        LoadableResource load = this.resources.get(resourceId);
        if (Objects.nonNull(load)) {
            try {
                if (load.loadFallback()) {
                    this.triggerListeners(resourceId, load.getDataStream());
                    return true;
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to load resource locally: " + resourceId, e);
            }
        } else {
            throw new IllegalArgumentException("No such resource: " + resourceId);
        }
        return false;
    }

    private boolean loadDataSynch(String resourceId) {
        LoadableResource load = this.resources.get(resourceId);
        if (Objects.nonNull(load)) {
            try {
                if (load.load()) {
                    this.triggerListeners(resourceId, load.getDataStream());
                    return true;
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to load resource: " + resourceId, e);
            }
        } else {
            throw new IllegalArgumentException("No such resource: " + resourceId);
        }
        return false;
    }

    @Override
    public void resetData(String dataId) throws IOException {
        LoadableResource load = Optional.ofNullable(this.resources.get(dataId)).orElseThrow(() -> new IllegalArgumentException("No such resource: " + dataId));
        if (load.resetToFallback()) {
            this.triggerListeners(dataId, load.getDataStream());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerListeners(String dataId, InputStream is) {
        List<LoaderService.LoaderListener> listeners;
        List<LoaderService.LoaderListener> list = listeners = this.getListeners("");
        synchronized (list) {
            for (LoaderService.LoaderListener ll : listeners) {
                try {
                    ll.newDataLoaded(dataId, is);
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Error calling LoadListener: " + ll, e);
                }
            }
        }
        if (!Objects.isNull(dataId) && !dataId.isEmpty()) {
            list = listeners = this.getListeners(dataId);
            synchronized (list) {
                for (LoaderService.LoaderListener ll : listeners) {
                    try {
                        ll.newDataLoaded(dataId, is);
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, "Error calling LoadListener: " + ll, e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLoaderListener(LoaderService.LoaderListener l, String ... dataIds) {
        if (dataIds.length == 0) {
            List<LoaderService.LoaderListener> listeners;
            List<LoaderService.LoaderListener> list = listeners = this.getListeners("");
            synchronized (list) {
                listeners.add(l);
            }
        } else {
            for (String dataId : dataIds) {
                List<LoaderService.LoaderListener> listeners;
                List<LoaderService.LoaderListener> list = listeners = this.getListeners(dataId);
                synchronized (list) {
                    listeners.add(l);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LoaderService.LoaderListener> getListeners(String dataId) {
        List<LoaderService.LoaderListener> listeners;
        if (Objects.isNull(dataId)) {
            dataId = "";
        }
        if (Objects.isNull(listeners = this.listenersMap.get(dataId))) {
            Map<String, List<LoaderService.LoaderListener>> map = this.listenersMap;
            synchronized (map) {
                listeners = this.listenersMap.get(dataId);
                if (Objects.isNull(listeners)) {
                    listeners = Collections.synchronizedList(new ArrayList());
                    this.listenersMap.put(dataId, listeners);
                }
            }
        }
        return listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLoaderListener(LoaderService.LoaderListener l, String ... dataIds) {
        if (dataIds.length == 0) {
            List<LoaderService.LoaderListener> listeners;
            List<LoaderService.LoaderListener> list = listeners = this.getListeners("");
            synchronized (list) {
                listeners.remove(l);
            }
        } else {
            for (String dataId : dataIds) {
                List<LoaderService.LoaderListener> listeners;
                List<LoaderService.LoaderListener> list = listeners = this.getListeners(dataId);
                synchronized (list) {
                    listeners.remove(l);
                }
            }
        }
    }

    @Override
    public LoaderService.UpdatePolicy getUpdatePolicy(String resourceId) {
        LoadableResource load = Optional.of(this.resources.get(resourceId)).orElseThrow(() -> new IllegalArgumentException("No such resource: " + resourceId));
        return load.getUpdatePolicy();
    }

    private void addScheduledLoad(final LoadableResource load) {
        Objects.requireNonNull(load);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    load.load();
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Failed to update remote resource: " + load.getResourceId(), e);
                }
            }
        };
        Map<String, String> props = load.getProperties();
        if (Objects.nonNull(props)) {
            String value = props.get("period");
            long periodMS = this.parseDuration(value);
            value = props.get("delay");
            long delayMS = this.parseDuration(value);
            if (periodMS > 0L) {
                this.timer.scheduleAtFixedRate(task, delayMS, periodMS);
            } else {
                value = props.get("at");
                if (Objects.nonNull(value)) {
                    List<GregorianCalendar> dates = this.parseDates(value);
                    dates.forEach(date -> this.timer.schedule(task, date.getTime(), 86400000L));
                }
            }
        }
    }

    private List<GregorianCalendar> parseDates(String value) {
        String[] parts = value.split(",");
        ArrayList<GregorianCalendar> result = new ArrayList<GregorianCalendar>();
        for (String part : parts) {
            if (part.isEmpty()) continue;
            String[] subparts = part.split(":");
            GregorianCalendar cal = new GregorianCalendar();
            block7: for (int i = 0; i < subparts.length; ++i) {
                switch (i) {
                    case 0: {
                        cal.set(11, Integer.parseInt(subparts[i]));
                        continue block7;
                    }
                    case 1: {
                        cal.set(12, Integer.parseInt(subparts[i]));
                        continue block7;
                    }
                    case 2: {
                        cal.set(13, Integer.parseInt(subparts[i]));
                        continue block7;
                    }
                    case 3: {
                        cal.set(14, Integer.parseInt(subparts[i]));
                    }
                }
            }
            result.add(cal);
        }
        return result;
    }

    protected long parseDuration(String value) {
        long periodMS = 0L;
        if (Objects.nonNull(value)) {
            String[] parts = value.split(":");
            block6: for (int i = 0; i < parts.length; ++i) {
                switch (i) {
                    case 0: {
                        periodMS += (long)Integer.parseInt(parts[i]) * 3600000L;
                        continue block6;
                    }
                    case 1: {
                        periodMS += (long)Integer.parseInt(parts[i]) * 60000L;
                        continue block6;
                    }
                    case 2: {
                        periodMS += (long)Integer.parseInt(parts[i]) * 1000L;
                        continue block6;
                    }
                    case 3: {
                        periodMS += (long)Integer.parseInt(parts[i]);
                        continue block6;
                    }
                }
            }
        }
        return periodMS;
    }

    public String toString() {
        return "DefaultLoaderService [resources=" + this.resources + ']';
    }
}

