/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.money.convert.ConversionQuery;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ExchangeRateProvider;
import javax.money.convert.ProviderContext;
import javax.money.convert.ProviderContextBuilder;
import org.javamoney.moneta.spi.AbstractRateProvider;

public class CompoundRateProvider
extends AbstractRateProvider {
    public static final String CHILD_PROVIDER_CONTEXTS_KEY = "childProviderContexts";
    private final List<ExchangeRateProvider> providers = new ArrayList<ExchangeRateProvider>();

    public CompoundRateProvider(Iterable<ExchangeRateProvider> providers) {
        super(CompoundRateProvider.createContext(providers));
        for (ExchangeRateProvider exchangeRateProvider : providers) {
            this.addProvider(exchangeRateProvider);
        }
    }

    private static ProviderContext createContext(Iterable<ExchangeRateProvider> providers) {
        HashSet rateTypeSet = new HashSet();
        StringBuilder providerName = new StringBuilder("Compound: ");
        ArrayList<ProviderContext> childContextList = new ArrayList<ProviderContext>();
        for (ExchangeRateProvider exchangeRateProvider : providers) {
            childContextList.add(exchangeRateProvider.getProviderContext());
            providerName.append(exchangeRateProvider.getProviderContext().getProvider());
            providerName.append(',');
            rateTypeSet.addAll(exchangeRateProvider.getProviderContext().getRateTypes());
        }
        providerName.setLength(providerName.length() - 1);
        ProviderContextBuilder builder = ProviderContextBuilder.of((String)providerName.toString(), rateTypeSet);
        builder.set(CHILD_PROVIDER_CONTEXTS_KEY, childContextList);
        return builder.build();
    }

    private void addProvider(ExchangeRateProvider prov) {
        this.providers.add(Optional.ofNullable(prov).orElseThrow(() -> new NullPointerException("ConversionProvider required.")));
    }

    @Override
    public ExchangeRate getExchangeRate(ConversionQuery conversionQuery) {
        for (ExchangeRateProvider prov : this.providers) {
            ExchangeRate rate;
            if (!prov.isAvailable(conversionQuery) || !Objects.nonNull(rate = prov.getExchangeRate(conversionQuery))) continue;
            return rate;
        }
        return null;
    }
}

