/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.convert.internal;

import java.io.InputStream;
import java.math.MathContext;
import java.net.MalformedURLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.money.CurrencyUnit;
import javax.money.MonetaryCurrencies;
import javax.money.convert.ConversionContextBuilder;
import javax.money.convert.ConversionQuery;
import javax.money.convert.CurrencyConversionException;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ProviderContext;
import javax.money.convert.RateType;
import javax.money.spi.Bootstrap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.javamoney.moneta.ExchangeRateBuilder;
import org.javamoney.moneta.convert.internal.RateReadingHandler;
import org.javamoney.moneta.spi.AbstractRateProvider;
import org.javamoney.moneta.spi.DefaultNumberValue;
import org.javamoney.moneta.spi.LoaderService;
import org.xml.sax.helpers.DefaultHandler;

abstract class AbstractECBCurrentRateProvider
extends AbstractRateProvider
implements LoaderService.LoaderListener {
    static final String BASE_CURRENCY_CODE = "EUR";
    public static final CurrencyUnit BASE_CURRENCY = MonetaryCurrencies.getCurrency((String)"EUR", (String[])new String[0]);
    private final Map<LocalDate, Map<String, ExchangeRate>> historicRates = new ConcurrentHashMap<LocalDate, Map<String, ExchangeRate>>();
    private SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();

    public AbstractECBCurrentRateProvider(ProviderContext context) throws MalformedURLException {
        super(context);
        this.saxParserFactory.setNamespaceAware(false);
        this.saxParserFactory.setValidating(false);
        LoaderService loader = (LoaderService)Bootstrap.getService(LoaderService.class);
        loader.addLoaderListener(this, this.getDataId());
        loader.loadDataAsync(this.getDataId());
    }

    public abstract String getDataId();

    @Override
    public void newDataLoaded(String data, InputStream is) {
        int oldSize = this.historicRates.size();
        try {
            SAXParser parser = this.saxParserFactory.newSAXParser();
            parser.parse(is, (DefaultHandler)new RateReadingHandler(this.historicRates, this.getContext()));
        }
        catch (Exception e) {
            this.LOGGER.log(Level.FINEST, "Error during data load.", e);
        }
        int newSize = this.historicRates.size();
        this.LOGGER.info("Loaded " + this.getDataId() + " exchange rates for days:" + (newSize - oldSize));
    }

    @Override
    public ExchangeRate getExchangeRate(ConversionQuery query) {
        Objects.requireNonNull(query);
        if (this.historicRates.isEmpty()) {
            return null;
        }
        LocalDate date = (LocalDate)query.get(LocalDate.class);
        if (date == null) {
            LocalDateTime dateTime = (LocalDateTime)query.get(LocalDateTime.class);
            date = dateTime != null ? dateTime.toLocalDate() : LocalDate.now().minus(Period.ofDays(1));
        }
        ExchangeRateBuilder builder = this.getBuilder(query, date);
        Map<String, ExchangeRate> targets = this.historicRates.get(date);
        if (Objects.isNull(targets)) {
            return null;
        }
        ExchangeRate sourceRate = targets.get(query.getBaseCurrency().getCurrencyCode());
        ExchangeRate target = targets.get(query.getCurrency().getCurrencyCode());
        return this.createExchangeRate(query, builder, sourceRate, target);
    }

    private ExchangeRate createExchangeRate(ConversionQuery query, ExchangeRateBuilder builder, ExchangeRate sourceRate, ExchangeRate target) {
        if (this.areBothBaseCurrencies(query)) {
            builder.setFactor(DefaultNumberValue.ONE);
            return builder.build();
        }
        if (BASE_CURRENCY_CODE.equals(query.getCurrency().getCurrencyCode())) {
            if (Objects.isNull(sourceRate)) {
                return null;
            }
            return this.reverse(sourceRate);
        }
        if (BASE_CURRENCY_CODE.equals(query.getBaseCurrency().getCurrencyCode())) {
            return target;
        }
        ExchangeRate rate1 = this.getExchangeRate(query.toBuilder().setTermCurrency(MonetaryCurrencies.getCurrency((String)BASE_CURRENCY_CODE, (String[])new String[0])).build());
        ExchangeRate rate2 = this.getExchangeRate(query.toBuilder().setBaseCurrency(MonetaryCurrencies.getCurrency((String)BASE_CURRENCY_CODE, (String[])new String[0])).setTermCurrency(query.getCurrency()).build());
        if (Objects.nonNull(rate1) && Objects.nonNull(rate2)) {
            builder.setFactor(AbstractECBCurrentRateProvider.multiply(rate1.getFactor(), rate2.getFactor()));
            builder.setRateChain(rate1, rate2);
            return builder.build();
        }
        throw new CurrencyConversionException(query.getBaseCurrency(), query.getCurrency(), sourceRate.getContext());
    }

    private boolean areBothBaseCurrencies(ConversionQuery query) {
        return BASE_CURRENCY_CODE.equals(query.getBaseCurrency().getCurrencyCode()) && BASE_CURRENCY_CODE.equals(query.getCurrency().getCurrencyCode());
    }

    private ExchangeRateBuilder getBuilder(ConversionQuery query, LocalDate localDate) {
        ExchangeRateBuilder builder = new ExchangeRateBuilder(((ConversionContextBuilder)ConversionContextBuilder.create((ProviderContext)this.getContext(), (RateType)RateType.HISTORIC).set((Object)localDate)).build());
        builder.setBase(query.getBaseCurrency());
        builder.setTerm(query.getCurrency());
        return builder;
    }

    private ExchangeRate reverse(ExchangeRate rate) {
        if (Objects.isNull(rate)) {
            throw new IllegalArgumentException("Rate null is not reversable.");
        }
        return new ExchangeRateBuilder(rate).setRate(rate).setBase(rate.getCurrency()).setTerm(rate.getBaseCurrency()).setFactor(AbstractECBCurrentRateProvider.divide(DefaultNumberValue.ONE, rate.getFactor(), MathContext.DECIMAL64)).build();
    }
}

